/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Strings;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.CloseableIterator;
import org.springframework.stereotype.Service;

@Service
class UpdateUniqueId {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateUniqueId.class);
    private static final String COLLECTION = "generationCheckpoint";
    private static final String CHECKPOINT = "checkpoint";
    private static final String CHECKPOINT_ID = "testItemId";
    private static final int BATCH_SIZE = 100;
    private static final String SECRET = "auto:";
    private static final Cache<String, Launch> launchCache = Caffeine.newBuilder().maximumSize(200L).build();
    @Autowired
    private MongoOperations mongoOperations;
    @Autowired
    private TestItemRepository testItemRepository;
    private static final AtomicBoolean STARTED = new AtomicBoolean();

    UpdateUniqueId() {
    }

    @EventListener
    public void onContextRefresh(ContextRefreshedEvent event) {
        if (STARTED.compareAndSet(false, true) && this.mongoOperations.collectionExists(COLLECTION)) {
            Executors.newSingleThreadExecutor().execute(() -> this.generateForAll());
        }
    }

    private void generateForAll() {
        boolean isOk;
        long forUpdate = this.mongoOperations.count(this.testItemQuery(), TestItem.class);
        long update = 0L;
        String checkpoint = this.getLastCheckpoint();
        do {
            try (CloseableIterator itemIterator = this.getItemIterator(checkpoint);){
                ArrayList<TestItem> testItems = new ArrayList<TestItem>(100);
                int counter = 0;
                while (itemIterator.hasNext()) {
                    boolean isRemoved;
                    TestItem testItem = (TestItem)itemIterator.next();
                    if (testItem == null || (isRemoved = this.removeIfInvalid(testItem))) continue;
                    if (checkpoint == null) {
                        checkpoint = testItem.getId();
                    }
                    String uniqueId = this.generate(testItem);
                    testItem.setUniqueId(uniqueId);
                    testItems.add(testItem);
                    if (testItems.size() != 100 && itemIterator.hasNext()) continue;
                    this.createCheckpoint(checkpoint);
                    this.updateTestItems(testItems);
                    if (++counter == 1000) {
                        LOGGER.info("Generated uniqueId for " + update + " items. It is " + (float)update / (float)forUpdate * 100.0f + "% done");
                        counter = 0;
                    }
                    update += (long)testItems.size();
                    testItems = new ArrayList(100);
                    checkpoint = null;
                }
                isOk = true;
            }
            catch (Exception e) {
                LOGGER.warn("Potential endless loop in reason of: ", (Throwable)e);
                isOk = false;
            }
        } while (!isOk);
        STARTED.set(false);
        this.mongoOperations.getCollection(COLLECTION).drop();
        launchCache.cleanUp();
        LOGGER.info("Generating uniqueId is done!");
        this.indexUniqueIds();
    }

    private void indexUniqueIds() {
        this.mongoOperations.indexOps(this.mongoOperations.getCollectionName(TestItem.class)).ensureIndex((IndexDefinition)new Index().on("uniqueId", Sort.Direction.ASC));
    }

    private void updateTestItems(List<TestItem> testItems) {
        BulkOperations bulk = this.mongoOperations.bulkOps(BulkOperations.BulkMode.UNORDERED, TestItem.class);
        testItems.forEach(it -> {
            Update update = new Update();
            update.set("uniqueId", (Object)it.getUniqueId());
            bulk.updateOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)it.getId())), update);
        });
        bulk.execute();
    }

    private boolean removeIfInvalid(TestItem item) {
        Launch launch;
        String launchRef = item.getLaunchRef();
        if (launchRef == null) {
            this.mongoOperations.remove((Object)Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)item.getId())));
        }
        if ((launch = (Launch)this.mongoOperations.findOne(this.launchQuery(launchRef), Launch.class)) == null) {
            this.testItemRepository.delete((Serializable)((Object)item.getId()));
            return true;
        }
        boolean exists = this.mongoOperations.exists(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)launch.getProjectRef())), Project.class);
        if (!exists) {
            this.mongoOperations.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)launchRef)), Launch.class);
            return true;
        }
        return false;
    }

    public String generate(TestItem testItem) {
        String forEncoding = this.prepareForEncoding(testItem);
        return SECRET + DigestUtils.md5Hex((String)forEncoding);
    }

    private String prepareForEncoding(TestItem testItem) {
        Launch launch = (Launch)launchCache.get((Object)testItem.getLaunchRef(), k -> (Launch)this.mongoOperations.findOne(this.launchQuery(testItem.getLaunchRef()), Launch.class));
        String launchName = launch.getName();
        String projectName = launch.getProjectRef();
        List pathNames = this.getPathNames(testItem.getPath());
        String itemName = testItem.getName();
        StringJoiner joiner = new StringJoiner(";");
        joiner.add(SECRET).add(projectName).add(launchName);
        if (!CollectionUtils.isEmpty((Collection)pathNames)) {
            joiner.add(pathNames.stream().collect(Collectors.joining(",")));
        }
        joiner.add(itemName);
        List parameters = testItem.getParameters();
        if (!CollectionUtils.isEmpty((Collection)parameters)) {
            joiner.add(parameters.stream().map(parameter -> (!Strings.isNullOrEmpty((String)parameter.getKey()) ? parameter.getKey() + "=" : "") + parameter.getValue()).collect(Collectors.joining(",")));
        }
        return joiner.toString();
    }

    private CloseableIterator<TestItem> getItemIterator(String checkpoint) {
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "_id")});
        Query query = new Query().with(sort).noCursorTimeout();
        if (checkpoint != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").gte((Object)new ObjectId(checkpoint)));
        }
        query.fields().include("name").include("path").include("launchRef").include("parameters");
        return this.mongoOperations.stream(query, TestItem.class);
    }

    private List<String> getPathNames(List<String> path) {
        Map names = this.testItemRepository.findPathNames(path);
        return path.stream().map(names::get).collect(Collectors.toList());
    }

    private Query launchQuery(String launchId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)launchId));
        query.fields().include("name");
        query.fields().include("projectRef");
        return query;
    }

    private Query testItemQuery() {
        Query query = new Query();
        query.fields().include("name").include("path").include("launchRef").include("parameters");
        return query;
    }

    private String getLastCheckpoint() {
        DBObject checkpoint = this.mongoOperations.getCollection(COLLECTION).findOne((DBObject)new BasicDBObject("_id", (Object)CHECKPOINT));
        return checkpoint == null ? null : (String)checkpoint.get(CHECKPOINT_ID);
    }

    private void createCheckpoint(String logId) {
        BasicDBObject checkpoint = new BasicDBObject("_id", (Object)CHECKPOINT).append(CHECKPOINT_ID, (Object)logId);
        this.mongoOperations.getCollection(COLLECTION).save((DBObject)checkpoint);
    }
}

