/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.history;

import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestItemsHistoryHandlerImpl
implements TestItemsHistoryHandler {
    private static final String LAUNCH_REF = "launchRef";
    private static final String UNIQUE_ID = "uniqueId";
    private TestItemRepository testItemRepository;
    private ITestItemsHistoryService historyService;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setHistoryService(ITestItemsHistoryService historyService) {
        this.historyService = historyService;
    }

    public List<TestItemHistoryElement> getItemsHistory(String projectName, String[] startPointsIds, int historyDepth, boolean showBrokenLaunches) {
        this.historyService.validateHistoryRequest(projectName, startPointsIds, historyDepth);
        ArrayList itemsIds = Lists.newArrayList((Object[])startPointsIds);
        List itemsForHistory = this.testItemRepository.findByIds((Collection)itemsIds, (List)Lists.newArrayList((Object[])new String[]{LAUNCH_REF, UNIQUE_ID}));
        this.historyService.validateItems(itemsForHistory, (List)itemsIds, projectName);
        List historyLaunches = this.historyService.loadLaunches(historyDepth, ((TestItem)itemsForHistory.get(0)).getLaunchRef(), projectName, showBrokenLaunches);
        List historyItems = this.testItemRepository.loadItemsHistory(itemsForHistory.stream().map(TestItem::getUniqueId).collect(Collectors.toList()), historyLaunches.stream().map(Launch::getId).collect(Collectors.toList()));
        Map<String, List<TestItem>> groupedItems = historyItems.stream().collect(Collectors.groupingBy(TestItem::getLaunchRef));
        return historyLaunches.stream().map(launch -> this.historyService.buildHistoryElement(launch, (List)groupedItems.get(launch.getId()))).collect(Collectors.toList());
    }
}

