/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.core.launch.IStartLaunchHandler;
import com.epam.ta.reportportal.database.dao.LaunchMetaInfoRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.events.LaunchStartedEvent;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
class StartLaunchHandler
implements IStartLaunchHandler {
    private final LaunchRepository launchRepository;
    private final LaunchMetaInfoRepository launchCounter;
    private final ProjectRepository projectRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public StartLaunchHandler(LaunchMetaInfoRepository launchCounter, ProjectRepository projectRepository, LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher) {
        this.launchCounter = launchCounter;
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
        this.eventPublisher = eventPublisher;
    }

    public StartLaunchRS startLaunch(String username, String projectName, StartLaunchRQ startLaunchRQ) {
        Project project;
        Project.UserConfig userConfig;
        if (startLaunchRQ.getMode() == Mode.DEBUG && (userConfig = ProjectUtils.findUserConfigByLogin((Project)(project = this.projectRepository.findByName(projectName)), (String)username)).getProjectRole() == ProjectRole.CUSTOMER) {
            startLaunchRQ.setMode(Mode.DEFAULT);
        }
        Launch launch = new LaunchBuilder().addStartRQ(startLaunchRQ).addProject(projectName).addStatus(Status.IN_PROGRESS).addUser(username).get();
        launch.setNumber(Long.valueOf(this.launchCounter.getLaunchNumber(launch.getName(), projectName)));
        launch.setApproximateDuration(this.calculateApproximateDuration(projectName, startLaunchRQ.getName(), 5));
        this.launchRepository.save((Object)launch);
        this.eventPublisher.publishEvent((Object)new LaunchStartedEvent(launch));
        return new StartLaunchRS(launch.getId(), launch.getNumber());
    }

    private double calculateApproximateDuration(String projectName, String launchName, int limit) {
        ImmutableSet conditions = ImmutableSet.builder().add((Object)new FilterCondition(Condition.EQUALS, false, launchName, "name")).add((Object)new FilterCondition(Condition.EQUALS, false, projectName, "project")).add((Object)new FilterCondition(Condition.IN, true, Status.STOPPED.name() + "," + Status.INTERRUPTED.name() + "," + Status.IN_PROGRESS.name(), "status")).add((Object)new FilterCondition(Condition.EQUALS, false, Mode.DEFAULT.name(), "mode")).build();
        Filter filter = new Filter(Launch.class, (Set)conditions);
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "start_time")});
        List launches = this.launchRepository.findByFilterWithSortingAndLimit(filter, sort, limit);
        return launches.stream().mapToLong(it -> it.getEndTime().getTime() - it.getStartTime().getTime()).average().orElse(0.0);
    }
}

