/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.log.ICreateLogHandler;
import com.epam.ta.reportportal.core.log.impl.CreateLogHandler;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.job.SaveBinaryDataJob;
import com.epam.ta.reportportal.ws.converter.builders.LogBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AsyncCreateLogHandler
extends CreateLogHandler
implements ICreateLogHandler {
    @Autowired
    private Provider<SaveBinaryDataJob> saveBinaryDataJob;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private ILogIndexer logIndexer;

    @Nonnull
    public EntryCreatedRS createLog(@Nonnull SaveLogRQ createLogRQ, MultipartFile file, String projectName) {
        Optional testItem = this.findTestItem(createLogRQ.getTestItemId());
        this.validate((TestItem)testItem.orElse(null), createLogRQ);
        Log log = (Log)((LogBuilder)this.logBuilder.get()).addSaveLogRQ(createLogRQ).addTestItem((TestItem)testItem.get()).build();
        try {
            this.logRepository.save((Object)log);
        }
        catch (Exception exc) {
            throw new ReportPortalException("Error while Log instance creating.", (Throwable)exc);
        }
        if (null != file) {
            this.taskExecutor.execute((Runnable)((SaveBinaryDataJob)this.saveBinaryDataJob.get()).withProject(projectName).withFile(file).withLog(log));
        }
        return new EntryCreatedRS(log.getId());
    }
}

