/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.SendCase;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.analyzer.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.project.IUpdateProjectHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.AnalyzeMode;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectAnalyzerConfig;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.ProjectSpecific;
import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.database.entity.project.InterruptionJobDelay;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.database.entity.user.UserUtils;
import com.epam.ta.reportportal.events.EmailConfigUpdatedEvent;
import com.epam.ta.reportportal.events.ProjectAnalyzerConfigEvent;
import com.epam.ta.reportportal.events.ProjectIndexEvent;
import com.epam.ta.reportportal.events.ProjectUpdatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.EmailConfigConverters;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.epam.ta.reportportal.ws.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfigDTO;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UpdateProjectHandler
implements IUpdateProjectHandler {
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final UserPreferenceRepository preferenceRepository;
    private final ApplicationEventPublisher publisher;
    @Autowired
    private ILogIndexer logIndexer;
    @Autowired
    @Qualifier(value="autoAnalyzeTaskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private AnalyzerStatusCache analyzerStatusCache;
    @Autowired
    private AnalyzerServiceClient analyzerServiceClient;

    @Autowired
    public UpdateProjectHandler(ProjectRepository projectRepository, UserRepository userRepository, UserPreferenceRepository userPreferenceRepository, ApplicationEventPublisher applicationEventPublisher) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.preferenceRepository = userPreferenceRepository;
        this.publisher = applicationEventPublisher;
    }

    public OperationCompletionRS updateProject(String projectName, UpdateProjectRQ updateProjectRQ, String principalName) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        Project before = (Project)SerializationUtils.clone((Serializable)project);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (null != updateProjectRQ.getCustomer()) {
            project.setCustomer(updateProjectRQ.getCustomer().trim());
        }
        project.setAddInfo(updateProjectRQ.getAddInfo());
        User principal = (User)this.userRepository.findOne((Serializable)((Object)principalName));
        if (null != updateProjectRQ.getUserRoles() && !principal.getRole().equals((Object)UserRole.ADMINISTRATOR)) {
            BusinessRule.expect(updateProjectRQ.getUserRoles().get(principalName), (Predicate)Predicates.isNull()).verify(ErrorType.UNABLE_TO_UPDATE_YOURSELF_ROLE, new Object[]{principalName});
        }
        if (null != updateProjectRQ.getUserRoles()) {
            for (Map.Entry user : updateProjectRQ.getUserRoles().entrySet()) {
                Optional role = ProjectRole.forName((String)((String)user.getValue()));
                BusinessRule.expect((Object)role, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{user.getValue()});
                ProjectRole projectRole = (ProjectRole)role.get();
                if (UserRole.ADMINISTRATOR != principal.getRole()) {
                    ProjectRole userRoleLevel;
                    ProjectRole principalRoleLevel = ProjectUtils.findUserConfigByLogin((Project)project, (String)principalName).getProjectRole();
                    if (principalRoleLevel.sameOrHigherThan(userRoleLevel = ProjectUtils.findUserConfigByLogin((Project)project, (String)((String)user.getKey())).getProjectRole())) {
                        BusinessRule.expect((Object)projectRole, (Predicate)Preconditions.isLevelEnough((ProjectRole)principalRoleLevel)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    } else {
                        BusinessRule.expect((Object)userRoleLevel, (Predicate)Preconditions.isLevelEnough((ProjectRole)principalRoleLevel)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    }
                }
                ProjectUtils.findUserConfigByLogin((Project)project, (String)((String)user.getKey())).setProjectRole((ProjectRole)role.get());
            }
        }
        if (null != updateProjectRQ.getConfiguration()) {
            this.processConfiguration(updateProjectRQ.getConfiguration(), project.getConfiguration(), projectName, principalName);
        }
        try {
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project", (Throwable)e);
        }
        this.publisher.publishEvent((Object)new ProjectUpdatedEvent(before, project, principalName, updateProjectRQ));
        return new OperationCompletionRS("Project with name = '" + projectName + "' is successfully updated.");
    }

    private void processConfiguration(ProjectConfiguration modelConfig, Project.Configuration dbConfig, String projectName, String principalName) {
        Optional.ofNullable(modelConfig.getKeepLogs()).ifPresent(keepLogs -> {
            BusinessRule.expect((Object)KeepLogsDelay.findByName((String)keepLogs), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
            dbConfig.setKeepLogs(keepLogs);
        });
        Optional.ofNullable(modelConfig.getInterruptJobTime()).ifPresent(jobTime -> {
            BusinessRule.expect((Object)InterruptionJobDelay.findByName((String)jobTime), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
            dbConfig.setInterruptJobTime(jobTime);
        });
        Optional.ofNullable(modelConfig.getKeepScreenshots()).ifPresent(keepScreens -> {
            BusinessRule.expect((Object)KeepScreenshotsDelay.findByName((String)keepScreens), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
            dbConfig.setKeepScreenshots(keepScreens);
        });
        Optional.ofNullable(modelConfig.getProjectSpecific()).ifPresent(specific -> {
            BusinessRule.expect((Object)ProjectSpecific.findByName((String)specific).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
            dbConfig.setProjectSpecific((ProjectSpecific)ProjectSpecific.findByName((String)specific).get());
        });
        Optional.ofNullable(modelConfig.getAnalyzerConfig()).ifPresent(analyzerConfig -> {
            BusinessRule.expect((Object)this.analyzerStatusCache.getAnalyzerStatus().asMap().containsValue(projectName), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Project settings can not be updated until auto-analysis proceeds"});
            ProjectAnalyzerConfig dbAnalyzerConfig = Optional.ofNullable(dbConfig.getAnalyzerConfig()).orElse(new ProjectAnalyzerConfig());
            ProjectAnalyzerConfig before = (ProjectAnalyzerConfig)SerializationUtils.clone((Serializable)dbAnalyzerConfig);
            Optional.ofNullable(analyzerConfig.getAnalyzerMode()).ifPresent(mode -> dbAnalyzerConfig.setAnalyzerMode(AnalyzeMode.fromString((String)mode)));
            Optional.ofNullable(analyzerConfig.getIsAutoAnalyzerEnabled()).ifPresent(arg_0 -> ((ProjectAnalyzerConfig)dbAnalyzerConfig).setIsAutoAnalyzerEnabled(arg_0));
            Optional.ofNullable(analyzerConfig.getMinDocFreq()).ifPresent(arg_0 -> ((ProjectAnalyzerConfig)dbAnalyzerConfig).setMinDocFreq(arg_0));
            Optional.ofNullable(analyzerConfig.getMinTermFreq()).ifPresent(arg_0 -> ((ProjectAnalyzerConfig)dbAnalyzerConfig).setMinTermFreq(arg_0));
            Optional.ofNullable(analyzerConfig.getMinShouldMatch()).ifPresent(arg_0 -> ((ProjectAnalyzerConfig)dbAnalyzerConfig).setMinShouldMatch(arg_0));
            Optional.ofNullable(analyzerConfig.getNumberOfLogLines()).ifPresent(arg_0 -> ((ProjectAnalyzerConfig)dbAnalyzerConfig).setNumberOfLogLines(arg_0));
            dbConfig.setAnalyzerConfig(dbAnalyzerConfig);
            this.publisher.publishEvent((Object)new ProjectAnalyzerConfigEvent(before, projectName, principalName, analyzerConfig));
        });
        Optional.ofNullable(modelConfig.getStatisticCalculationStrategy()).ifPresent(strategy -> dbConfig.setStatisticsCalculationStrategy((StatisticsCalculationStrategy)StatisticsCalculationStrategy.fromString((String)strategy).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect statistics calculation type: " + strategy}))));
        Optional.ofNullable(modelConfig.getEmailConfig()).ifPresent(emailConfig -> this.updateProjectEmailConfig(projectName, principalName, modelConfig.getEmailConfig()));
    }

    public OperationCompletionRS updateProjectEmailConfig(String projectName, String user, ProjectEmailConfigDTO configUpdate) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        Project beforeUpdate = (Project)SerializationUtils.clone((Serializable)project);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        boolean emailEnabled = BooleanUtils.isTrue((Boolean)configUpdate.getEmailEnabled());
        project.getConfiguration().getEmailConfig().setEmailEnabled(Boolean.valueOf(emailEnabled));
        List cases = configUpdate.getEmailCases();
        Optional.ofNullable(configUpdate.getFrom()).ifPresent(from -> {
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)configUpdate.getFrom()), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided FROM value '{}' is invalid", (Object[])new Object[]{configUpdate.getFrom()})});
            project.getConfiguration().getEmailConfig().setFrom(configUpdate.getFrom());
        });
        BusinessRule.expect((Object)cases, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"At least one rule should be present."});
        cases.forEach(sendCase -> {
            BusinessRule.expect((Object)SendCase.findByName((String)sendCase.getSendCase()).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{sendCase.getSendCase()});
            BusinessRule.expect((Object)sendCase.getRecipients(), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Recipients list should not be null"});
            BusinessRule.expect((Object)sendCase.getRecipients().isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Empty recipients list for email case '{}' ", (Object[])new Object[]{sendCase})});
            sendCase.setRecipients(sendCase.getRecipients().stream().map(it -> {
                this.validateRecipient(project, it);
                return it.trim();
            }).distinct().collect(Collectors.toList()));
            if (null != sendCase.getLaunchNames()) {
                sendCase.setLaunchNames(sendCase.getLaunchNames().stream().map(name -> {
                    this.validateLaunchName(name);
                    return name.trim();
                }).distinct().collect(Collectors.toList()));
            }
            if (null != sendCase.getTags()) {
                sendCase.setTags(sendCase.getTags().stream().map(tag -> {
                    BusinessRule.expect((Object)Strings.isNullOrEmpty((String)tag), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Tags values cannot be empty. Please specify it or not include in request."});
                    return tag.trim();
                }).distinct().collect(Collectors.toList()));
            }
        });
        List withoutDuplicateCases = cases.stream().distinct().map(EmailConfigConverters.TO_CASE_MODEL).collect(Collectors.toList());
        if (cases.size() != withoutDuplicateCases.size()) {
            BusinessRule.fail().withError(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Project email settings contain duplicate cases"});
        }
        project.getConfiguration().getEmailConfig().setEmailCases(withoutDuplicateCases);
        try {
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project", (Throwable)e);
        }
        this.publisher.publishEvent((Object)new EmailConfigUpdatedEvent(beforeUpdate, configUpdate, user));
        return new OperationCompletionRS("EMail configuration of project with name = '" + projectName + "' is successfully updated.");
    }

    public OperationCompletionRS unassignUsers(String projectName, String modifier, UnassignUsersRQ unassignUsersRQ) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        EntryType projectType = project.getConfiguration().getEntryType();
        User principal = (User)this.userRepository.findOne((Serializable)((Object)modifier));
        if (UserRole.ADMINISTRATOR != principal.getRole()) {
            BusinessRule.expect((Object)unassignUsersRQ.getUsernames(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)modifier)))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not unassign himself from project."});
        }
        List users = project.getUsers();
        ArrayList<String> candidatesForUnassign = new ArrayList<String>();
        for (Object login : unassignUsersRQ.getUsernames()) {
            User singleUser = (User)this.userRepository.findOne((Serializable)login);
            BusinessRule.expect((Object)singleUser, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{login, "User is not found in database."});
            UserType userType = singleUser.getType();
            if (EntryType.PERSONAL.equals((Object)projectType) && projectName.startsWith(singleUser.getId())) {
                BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Unable to unassign user from his personal project"});
            }
            if (projectType.equals((Object)EntryType.UPSA) && userType.equals((Object)UserType.UPSA)) {
                BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Project and user has UPSA type!"});
            }
            if (!ProjectUtils.doesHaveUser((Project)project, (String)singleUser.getId())) {
                BusinessRule.fail().withError(ErrorType.USER_NOT_FOUND, new Object[]{singleUser.getId(), String.format("User not found in project %s", projectName)});
            }
            if (UserRole.ADMINISTRATOR != principal.getRole()) {
                BusinessRule.expect((Object)ProjectUtils.findUserConfigByLogin((Project)project, (String)singleUser.getId()).getProjectRole(), (Predicate)Preconditions.isLevelEnough((ProjectRole)ProjectUtils.findUserConfigByLogin((Project)project, (String)modifier).getProjectRole())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
            candidatesForUnassign.add(singleUser.getId());
            users.removeIf(it -> singleUser.getId().equals(it.getLogin()));
        }
        Iterable dbUsers = this.userRepository.findAll(candidatesForUnassign);
        this.processCandidateForUnaassign(dbUsers, projectName);
        project = ProjectUtils.excludeProjectRecipients((Iterable)dbUsers, (Project)project);
        try {
            project.setUsers(users);
            this.projectRepository.save(project);
            for (String user : unassignUsersRQ.getUsernames()) {
                String normalized = user.toLowerCase();
                this.preferenceRepository.deleteByUsernameAndProject(normalized, projectName);
            }
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project ", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        String msg = "User(s) with username(s)='" + unassignUsersRQ.getUsernames() + "' was successfully un-assigned from project='" + projectName + "'";
        response.setResultMessage(msg);
        return response;
    }

    public OperationCompletionRS assignUsers(String projectName, String modifier, AssignUsersRQ assignUsersRQ) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        EntryType projectType = project.getConfiguration().getEntryType();
        User principal = (User)this.userRepository.findOne((Serializable)((Object)modifier));
        if (!principal.getRole().equals((Object)UserRole.ADMINISTRATOR)) {
            BusinessRule.expect(assignUsersRQ.getUserNames().keySet(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)modifier)))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not assign himself to project."});
        }
        for (String username : assignUsersRQ.getUserNames().keySet()) {
            BusinessRule.expect((Object)username.toLowerCase(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)project.getUsers().stream().map(Project.UserConfig::getLogin).collect(Collectors.toList())))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{Suppliers.formattedSupplier((String)"User '{}' cannot be assigned to project twice.", (Object[])new Object[]{username})});
        }
        Project.UserConfig principalRoles = ProjectUtils.findUserConfigByLogin((Project)project, (String)modifier);
        List users = project.getUsers();
        for (String username : assignUsersRQ.getUserNames().keySet()) {
            User user = (User)this.userRepository.findOne((Serializable)((Object)username.toLowerCase()));
            BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
            UserType userType = user.getType();
            if (projectType.equals((Object)EntryType.UPSA) && userType.equals((Object)UserType.UPSA)) {
                BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Project and user has UPSA type!"});
            }
            Project.UserConfig config = new Project.UserConfig();
            String userToAssign = (String)assignUsersRQ.getUserNames().get(username);
            if (!Strings.isNullOrEmpty((String)userToAssign)) {
                config.setLogin(username.toLowerCase());
                Optional proposedRoleOptional = ProjectRole.forName((String)userToAssign);
                BusinessRule.expect((Object)proposedRoleOptional, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{userToAssign});
                ProjectRole proposedRole = (ProjectRole)proposedRoleOptional.get();
                if (principal.getRole() != UserRole.ADMINISTRATOR) {
                    ProjectRole creatorProjectRoleLevel = principalRoles.getProjectRole();
                    ProjectRole newUserProjectRoleLevel = proposedRole;
                    BusinessRule.expect((Object)creatorProjectRoleLevel.sameOrHigherThan(newUserProjectRoleLevel), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    config.setProjectRole(proposedRole);
                    config.setProposedRole(proposedRole);
                } else {
                    config.setProjectRole(proposedRole);
                    config.setProposedRole(proposedRole);
                }
            } else {
                config.setProjectRole(ProjectRole.MEMBER);
                config.setProposedRole(ProjectRole.MEMBER);
            }
            users.add(config);
        }
        try {
            project.setUsers(users);
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during updating Project", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        String msg = "User(s) with username='" + assignUsersRQ.getUserNames().keySet() + "' was successfully assigned to project='" + projectName + "'";
        response.setResultMessage(msg);
        return response;
    }

    public OperationCompletionRS indexProjectData(String projectName, String username) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        BusinessRule.expect((Object)project.getConfiguration().getAnalyzerConfig().isIndexingRunning(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        BusinessRule.expect((Object)this.analyzerStatusCache.getAnalyzerStatus().asMap().containsValue(projectName), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until auto-analysis proceeds."});
        BusinessRule.expect((Object)this.analyzerServiceClient.hasClients(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{"There are no analyzer's clients."});
        User user = (User)this.userRepository.findOne((Serializable)((Object)username));
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
        this.projectRepository.enableProjectIndexing(projectName, true);
        this.logIndexer.deleteIndex(projectName);
        this.taskExecutor.execute(() -> this.logIndexer.indexProjectData(project, user));
        this.publisher.publishEvent((Object)new ProjectIndexEvent(projectName, username, true));
        return new OperationCompletionRS("Log indexing has been started");
    }

    void validateRecipient(Project project, String recipient) {
        BusinessRule.expect((Object)recipient, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided recipient email '{}' is invalid", (Object[])new Object[]{recipient})});
        if (recipient.contains("@")) {
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)recipient), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Provided recipient email '{}' is invalid", (Object[])new Object[]{recipient})});
        } else {
            String login = recipient.trim();
            BusinessRule.expect((Object)(1 <= login.length() && login.length() <= 128 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Acceptable login length  [1..128]"});
            if (!ProjectUtils.getOwner().equals(login)) {
                BusinessRule.expect((Object)ProjectUtils.doesHaveUser((Project)project, (String)login.toLowerCase()), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.USER_NOT_FOUND, new Object[]{login, String.format("User not found in project %s", project.getId())});
            }
        }
    }

    void validateLaunchName(String name) {
        BusinessRule.expect((Object)Strings.isNullOrEmpty((String)name), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch name values cannot be empty. Please specify it or not include in request."});
        BusinessRule.expect((Object)(name.length() <= 256 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"One of provided launch names '{}' is too long. Acceptable name length is [1..256]", (Object[])new Object[]{name})});
    }

    private void processCandidateForUnaassign(Iterable<User> users, String projectName) {
        List updated = StreamSupport.stream(users.spliterator(), false).filter(it -> it.getDefaultProject().equals(projectName)).peek(it -> this.projectRepository.findPersonalProjectName(it.getId()).ifPresent(arg_0 -> ((User)it).setDefaultProject(arg_0))).collect(Collectors.toList());
        this.userRepository.save(updated);
    }
}

