/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PassingRateFilterStrategy
implements BuildFilterStrategy {
    private static final String LAUNCH_NAME_FIELD = "launchNameFilter";
    @Autowired
    private LaunchRepository launchRepository;

    public Map<String, List<ChartObject>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        Map<String, List<ChartObject>> emptyResult = Collections.emptyMap();
        if (contentOptions.getWidgetOptions() == null || contentOptions.getWidgetOptions().get(LAUNCH_NAME_FIELD) == null) {
            return emptyResult;
        }
        Launch lastLaunchForProject = this.launchRepository.findLatestLaunch(projectName, (String)((List)contentOptions.getWidgetOptions().get(LAUNCH_NAME_FIELD)).get(0), Mode.DEFAULT.name()).orElse(null);
        if (null == lastLaunchForProject) {
            return emptyResult;
        }
        ChartObject chartObject = this.processStatistics(lastLaunchForProject);
        return ImmutableMap.builder().put((Object)"result", Collections.singletonList(chartObject)).build();
    }

    private ChartObject processStatistics(Launch lastLaunch) {
        ChartObject chartObject = new ChartObject();
        chartObject.setValues((Map)ImmutableMap.builder().put((Object)"total", (Object)String.valueOf(lastLaunch.getStatistics().getExecutionCounter().getTotal())).put((Object)"passed", (Object)String.valueOf(lastLaunch.getStatistics().getExecutionCounter().getPassed())).build());
        return chartObject;
    }
}

