/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.DefectTypeCreatedEvent;
import com.epam.ta.reportportal.events.DefectTypeDeletedEvent;
import com.epam.ta.reportportal.events.DefectTypeUpdatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DefectTypeActivityHandler {
    private final ActivityRepository activityRepository;

    @Autowired
    public DefectTypeActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onDefectTypeCreated(DefectTypeCreatedEvent event) {
        Activity activity = new ActivityBuilder().addLoggedObjectRef(event.getStatisticSubType().getLocator()).addProjectRef(event.getProject().toLowerCase()).addObjectType(ActivityObjectType.DEFECT_TYPE).addObjectName(event.getStatisticSubType().getLongName()).addActionType(ActivityEventType.UPDATE_DEFECT).addUserRef(event.getUser()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)event.getStatisticSubType().getLongName()))).get();
        this.activityRepository.save((Object)activity);
    }

    @EventListener
    public void onDefectTypeUpdated(DefectTypeUpdatedEvent event) {
        List activities = event.getRequest().getIds().stream().map(subType -> new ActivityBuilder().addProjectRef(event.getProject()).addObjectType(ActivityObjectType.DEFECT_TYPE).addObjectName(subType.getLongName()).addActionType(ActivityEventType.UPDATE_DEFECT).addLoggedObjectRef(subType.getId()).addUserRef(event.getUpdatedBy()).get()).collect(Collectors.toList());
        this.activityRepository.save(activities);
    }

    @EventListener
    public void onDefectTypeDeleted(DefectTypeDeletedEvent event) {
        Project projectSettings = event.getBefore();
        projectSettings.getConfiguration().getSubTypes().values().stream().flatMap(Collection::stream).filter(it -> it.getLocator().equalsIgnoreCase(event.getId())).findFirst().ifPresent(subType -> {
            Activity activity = new ActivityBuilder().addProjectRef(projectSettings.getName()).addObjectType(ActivityObjectType.DEFECT_TYPE).addActionType(ActivityEventType.DELETE_DEFECT).addLoggedObjectRef(event.getId()).addUserRef(event.getUpdatedBy().toLowerCase()).addObjectName(subType.getLongName()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)subType.getLongName(), (String)""))).get();
            this.activityRepository.save((Object)activity);
        });
    }
}

