/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.LaunchDeletedEvent;
import com.epam.ta.reportportal.events.LaunchFinishForcedEvent;
import com.epam.ta.reportportal.events.LaunchFinishedEvent;
import com.epam.ta.reportportal.events.LaunchStartedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class LaunchActivityHandler {
    private static final String DELIMITER = " #";
    private final ActivityRepository activityRepository;

    @Autowired
    public LaunchActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onLaunchFinish(LaunchFinishedEvent event) {
        this.afterLaunchFinished(event.getLaunch(), event.getLaunch().getUserRef());
    }

    @EventListener
    public void onLaunchForceFinish(LaunchFinishForcedEvent event) {
        this.afterLaunchFinished(event.getLaunch(), event.getForcedBy());
    }

    @EventListener
    public void onLaunchStart(LaunchStartedEvent event) {
        Launch launch = event.getLaunch();
        if (Mode.DEBUG != event.getLaunch().getMode()) {
            String name = launch.getName() + DELIMITER + launch.getNumber();
            Activity activityLog = new ActivityBuilder().addUserRef(launch.getUserRef()).addProjectRef(launch.getProjectRef().toLowerCase()).addActionType(ActivityEventType.START_LAUNCH).addObjectType(ActivityObjectType.LAUNCH).addLoggedObjectRef(launch.getId()).addObjectName(name).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)name))).get();
            this.activityRepository.save((Object)activityLog);
        }
    }

    @EventListener
    public void onDeleteLaunch(LaunchDeletedEvent event) {
        Launch launch = event.getLaunch();
        if (null != launch && launch.getMode() == Mode.DEFAULT) {
            String name = launch.getName() + DELIMITER + launch.getNumber();
            Activity activity = new ActivityBuilder().addUserRef(event.getDeletedBy()).addProjectRef(event.getLaunch().getProjectRef()).addActionType(ActivityEventType.DELETE_LAUNCH).addObjectType(ActivityObjectType.LAUNCH).addLoggedObjectRef(launch.getId()).addObjectName(name).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)name, (String)""))).get();
            this.activityRepository.save((Object)activity);
        }
    }

    private void afterLaunchFinished(Launch launch, String finishedBy) {
        if (launch.getMode() != Mode.DEBUG) {
            String name = launch.getName() + DELIMITER + launch.getNumber();
            Activity activityLog = new ActivityBuilder().addUserRef(finishedBy).addProjectRef(launch.getProjectRef()).addActionType(ActivityEventType.FINISH_LAUNCH).addObjectType(ActivityObjectType.LAUNCH).addLoggedObjectRef(launch.getId()).addObjectName(name).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)name, (String)name))).get();
            this.activityRepository.save((Object)activityLog);
        }
    }
}

