/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.AnalyzeMode;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectAnalyzerConfig;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.ProjectAnalyzerConfigEvent;
import com.epam.ta.reportportal.events.ProjectUpdatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ProjectActivityHandler {
    static final String KEEP_SCREENSHOTS = "keepScreenshots";
    static final String KEEP_LOGS = "keepLogs";
    static final String LAUNCH_INACTIVITY = "launchInactivity";
    static final String STATISTICS_CALCULATION_STRATEGY = "statisticsCalculationStrategy";
    static final String AUTO_ANALYZE = "auto_analyze";
    static final String ANALYZE_MODE = "analyze_mode";
    static final String MIN_DOC_FREQ = "min_doc_freq";
    static final String MIN_TERM_FREQ = "min_term_freq";
    static final String MIN_SHOULD_MATCH = "min_should_match";
    static final String NUMBER_OF_LOG_LINES = "number_of_log_lines";
    private final ActivityRepository activityRepository;

    @Autowired
    public ProjectActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onAnalyzerEvent(ProjectAnalyzerConfigEvent event) {
        ArrayList history = Lists.newArrayList();
        Optional.ofNullable(event.getAnalyzerConfig()).ifPresent(updated -> {
            this.processAnalyzerConfig(history, (ProjectAnalyzerConfig)event.getBefore(), updated);
            this.processAutoAnalyze(history, (ProjectAnalyzerConfig)event.getBefore(), updated);
        });
        if (!history.isEmpty()) {
            Activity activityLog = new ActivityBuilder().addProjectRef(event.getProjectRef()).addObjectType(ActivityObjectType.PROJECT).addObjectName(event.getProjectRef()).addActionType(ActivityEventType.UPDATE_ANALYZER).addUserRef(event.getUpdatedBy()).addHistory((List)history).get();
            this.activityRepository.save((Object)activityLog);
        }
    }

    @EventListener
    public void onApplicationEvent(ProjectUpdatedEvent event) {
        Project project = (Project)event.getBefore();
        ArrayList history = Lists.newArrayList();
        ProjectConfiguration configuration = event.getUpdateProjectRQ().getConfiguration();
        if (null != configuration) {
            this.processKeepLogs((List)history, project, configuration);
            this.processKeepScreenshots((List)history, project, configuration);
            this.processLaunchInactivityTimeout((List)history, project, configuration);
            this.processStatisticsStrategy((List)history, project, configuration);
        }
        if (!history.isEmpty()) {
            Activity activityLog = new ActivityBuilder().addProjectRef(project.getName()).addObjectType(ActivityObjectType.PROJECT).addObjectName(project.getName()).addActionType(ActivityEventType.UPDATE_PROJECT).addUserRef(event.getUpdatedBy()).addHistory((List)(history.isEmpty() ? null : history)).get();
            this.activityRepository.save((Object)activityLog);
        }
    }

    private void processAnalyzerConfig(List<Activity.FieldValues> history, ProjectAnalyzerConfig projectAnalyzerConfig, AnalyzerConfig analyzerConfig) {
        if (analyzerConfig != null) {
            this.processAnalyzeMode(history, projectAnalyzerConfig, AnalyzeMode.fromString((String)analyzerConfig.getAnalyzerMode()));
            this.processElasticParameters(history, MIN_DOC_FREQ, Integer.valueOf(projectAnalyzerConfig.getMinDocFreq()), analyzerConfig.getMinDocFreq());
            this.processElasticParameters(history, MIN_TERM_FREQ, Integer.valueOf(projectAnalyzerConfig.getMinTermFreq()), analyzerConfig.getMinTermFreq());
            this.processElasticParameters(history, MIN_SHOULD_MATCH, Integer.valueOf(projectAnalyzerConfig.getMinShouldMatch()), analyzerConfig.getMinShouldMatch());
            this.processElasticParameters(history, NUMBER_OF_LOG_LINES, Integer.valueOf(projectAnalyzerConfig.getNumberOfLogLines()), analyzerConfig.getNumberOfLogLines());
        }
    }

    private void processElasticParameters(List<Activity.FieldValues> history, String elasticParameterName, Integer oldValue, Integer newValue) {
        Optional.ofNullable(newValue).ifPresent(param -> {
            if (!param.equals(oldValue)) {
                history.add(EventHandlerUtil.createHistoryField((String)elasticParameterName, (String)String.valueOf(oldValue), (String)String.valueOf(param)));
            }
        });
    }

    private void processAnalyzeMode(List<Activity.FieldValues> history, ProjectAnalyzerConfig projectAnalyzerConfig, AnalyzeMode mode) {
        AnalyzeMode oldMode = projectAnalyzerConfig.getAnalyzerMode();
        if (null != mode && mode != oldMode) {
            history.add(EventHandlerUtil.createHistoryField((String)ANALYZE_MODE, (String)(oldMode != null ? oldMode.getValue() : ""), (String)mode.getValue()));
        }
    }

    private void processStatisticsStrategy(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getStatisticCalculationStrategy() && !configuration.getStatisticCalculationStrategy().equalsIgnoreCase(project.getConfiguration().getStatisticsCalculationStrategy().name())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)STATISTICS_CALCULATION_STRATEGY, (String)project.getConfiguration().getStatisticsCalculationStrategy().name(), (String)configuration.getStatisticCalculationStrategy());
            history.add(fieldValues);
        }
    }

    private void processKeepLogs(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getKeepLogs() && !configuration.getKeepLogs().equals(project.getConfiguration().getKeepLogs())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)KEEP_LOGS, (String)project.getConfiguration().getKeepLogs(), (String)configuration.getKeepLogs());
            history.add(fieldValues);
        }
    }

    private void processLaunchInactivityTimeout(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getInterruptJobTime() && !configuration.getInterruptJobTime().equals(project.getConfiguration().getInterruptJobTime())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)LAUNCH_INACTIVITY, (String)project.getConfiguration().getInterruptJobTime(), (String)configuration.getInterruptJobTime());
            history.add(fieldValues);
        }
    }

    private void processAutoAnalyze(List<Activity.FieldValues> history, ProjectAnalyzerConfig projectAnalyzerConfig, AnalyzerConfig analyzerConfig) {
        if (null != analyzerConfig.getIsAutoAnalyzerEnabled() && !analyzerConfig.getIsAutoAnalyzerEnabled().equals(projectAnalyzerConfig.getIsAutoAnalyzerEnabled())) {
            String oldValue = projectAnalyzerConfig.getIsAutoAnalyzerEnabled() == null ? "" : projectAnalyzerConfig.getIsAutoAnalyzerEnabled().toString();
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)AUTO_ANALYZE, (String)oldValue, (String)analyzerConfig.getIsAutoAnalyzerEnabled().toString());
            history.add(fieldValues);
        }
    }

    private void processKeepScreenshots(List<Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getKeepScreenshots() && !configuration.getKeepScreenshots().equals(project.getConfiguration().getKeepScreenshots())) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)KEEP_SCREENSHOTS, (String)project.getConfiguration().getKeepScreenshots(), (String)configuration.getKeepScreenshots());
            history.add(fieldValues);
        }
    }
}

