/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.EmailConfigUpdatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.converter.converters.EmailConfigConverters;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfigDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ProjectEmailUpdatedHandler {
    private static final String EMAIL_STATUS = "emailEnabled";
    private static final String EMAIL_CASES = "emailCases";
    private static final String EMAIL_FROM = "from";
    private final ActivityRepository activityRepository;

    @Autowired
    public ProjectEmailUpdatedHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onProjectEmailUpdate(EmailConfigUpdatedEvent event) {
        ArrayList history = Lists.newArrayList();
        ProjectEmailConfigDTO configuration = event.getUpdateProjectEmailRQ();
        if (null != configuration) {
            this.processEmailConfiguration((List)history, (Project)event.getBefore(), configuration);
        }
        if (!history.isEmpty()) {
            Activity activityLog = new ActivityBuilder().addProjectRef(((Project)event.getBefore()).getName()).addObjectType(ActivityObjectType.PROJECT).addObjectName(((Project)event.getBefore()).getName()).addActionType(ActivityEventType.UPDATE_PROJECT).addUserRef(event.getUpdatedBy()).addHistory((List)history).get();
            this.activityRepository.save((Object)activityLog);
        }
    }

    private void processEmailConfiguration(List<Activity.FieldValues> history, Project project, ProjectEmailConfigDTO configuration) {
        boolean isEmailCasesChanged;
        boolean isEmailOptionChanged = configuration.getEmailEnabled() != null && !configuration.getEmailEnabled().equals(project.getConfiguration().getEmailConfig().getEmailEnabled());
        boolean isEmailFromChanged = null != configuration.getFrom() && !configuration.getFrom().equalsIgnoreCase(project.getConfiguration().getEmailConfig().getFrom());
        ProjectEmailConfigDTO builtProjectEmailConfig = (ProjectEmailConfigDTO)EmailConfigConverters.TO_RESOURCE.apply(project.getConfiguration().getEmailConfig());
        boolean bl = isEmailCasesChanged = null != configuration.getEmailCases() && !configuration.getEmailCases().equals(builtProjectEmailConfig.getEmailCases());
        if (isEmailOptionChanged) {
            Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)EMAIL_STATUS, (String)String.valueOf(project.getConfiguration().getEmailConfig().getEmailEnabled()), (String)String.valueOf(configuration.getEmailEnabled()));
            history.add(fieldValues);
        } else {
            if (isEmailCasesChanged) {
                history.add(EventHandlerUtil.createHistoryField((String)EMAIL_CASES, (String)"", (String)""));
            }
            if (isEmailFromChanged) {
                Activity.FieldValues fieldValues = EventHandlerUtil.createHistoryField((String)EMAIL_FROM, (String)project.getConfiguration().getEmailConfig().getFrom(), (String)configuration.getFrom());
                history.add(fieldValues);
            }
        }
    }
}

