/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.events.ItemIssueTypeDefined;
import com.epam.ta.reportportal.events.TicketAttachedEvent;
import com.epam.ta.reportportal.events.TicketPostedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.issue.IssueDefinition;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class TicketActivitySubscriber {
    public static final String TICKET_ID = "ticketId";
    public static final String ISSUE_TYPE = "issueType";
    public static final String IGNORE_ANALYZER = "ignoreAnalyzer";
    public static final String COMMENT = "comment";
    private final ActivityRepository activityRepository;
    private final TestItemRepository testItemRepository;
    private final ProjectRepository projectSettingsRepository;

    @Autowired
    public TicketActivitySubscriber(ActivityRepository activityRepository, TestItemRepository testItemRepository, ProjectRepository projectSettingsRepository) {
        this.activityRepository = activityRepository;
        this.testItemRepository = testItemRepository;
        this.projectSettingsRepository = projectSettingsRepository;
    }

    @EventListener
    public void onTicketPosted(TicketPostedEvent event) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)event.getTestItemId()));
        String oldValue = null;
        String separator = ",";
        if (null != testItem && null != testItem.getIssue()) {
            oldValue = this.issuesIdsToString(testItem.getIssue().getExternalSystemIssues(), separator);
        }
        String newValue = null == oldValue ? event.getTicket().getId() + ":" + event.getTicket().getTicketUrl() : oldValue + separator + event.getTicket().getId() + ":" + event.getTicket().getTicketUrl();
        ArrayList history = Lists.newArrayList();
        Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withField(TICKET_ID).withOldValue(oldValue).withNewValue(newValue);
        history.add(fieldValues);
        Activity activity = new ActivityBuilder().addProjectRef(event.getProject()).addActionType(ActivityEventType.POST_ISSUE).addLoggedObjectRef(event.getTestItemId()).addObjectType(ActivityObjectType.TEST_ITEM).addObjectName(event.getItemName()).addUserRef(event.getPostedBy()).addHistory((List)history).get();
        this.activityRepository.save((Object)activity);
    }

    @EventListener
    public void onTicketAttached(TicketAttachedEvent event) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        String separator = ",";
        Iterable testItems = (Iterable)event.getBefore();
        Map<String, Activity.FieldValues> results = StreamSupport.stream(testItems.spliterator(), false).filter(item -> null != item.getIssue()).collect(Collectors.toMap(TestItem::getId, item -> Activity.FieldValues.newOne().withOldValue(this.issuesIdsToString(item.getIssue().getExternalSystemIssues(), separator))));
        Iterable updated = (Iterable)event.getAfter();
        for (TestItem testItem : updated) {
            ActivityEventType type;
            if (null == testItem.getIssue()) continue;
            Activity.FieldValues fieldValues = results.get(testItem.getId());
            String newValue = this.issuesIdsToString(testItem.getIssue().getExternalSystemIssues(), separator);
            fieldValues.withField(TICKET_ID).withNewValue(newValue);
            ActivityEventType activityEventType = type = testItem.getIssue().isAutoAnalyzed() ? ActivityEventType.LINK_ISSUE_AA : ActivityEventType.LINK_ISSUE;
            if (Strings.isNullOrEmpty((String)fieldValues.getOldValue()) && newValue.isEmpty() || fieldValues.getOldValue().equalsIgnoreCase(newValue)) {
                return;
            }
            if (!Strings.isNullOrEmpty((String)fieldValues.getOldValue()) && fieldValues.getOldValue().length() > newValue.length()) {
                type = ActivityEventType.UNLINK_ISSUE;
            }
            Activity activity = new ActivityBuilder().addProjectRef(event.getProject()).addActionType(type).addLoggedObjectRef(testItem.getId()).addObjectType(ActivityObjectType.TEST_ITEM).addObjectName(testItem.getName()).addUserRef(event.getPostedBy()).addHistory(Collections.singletonList(fieldValues)).get();
            activities.add(activity);
        }
        this.activityRepository.save(activities);
    }

    @EventListener
    public void onIssueTypeDefined(ItemIssueTypeDefined itemIssueTypeDefined) {
        Map data = itemIssueTypeDefined.getBefore();
        List activities = this.processTestItemIssues(itemIssueTypeDefined.getProject(), itemIssueTypeDefined.getPostedBy(), data);
        if (!activities.isEmpty()) {
            this.activityRepository.save((Iterable)activities);
        }
    }

    private String issuesIdsToString(Set<TestItemIssue.ExternalSystemIssue> externalSystemIssues, String separator) {
        if (null != externalSystemIssues && !externalSystemIssues.isEmpty()) {
            return externalSystemIssues.stream().map(externalSystemIssue -> externalSystemIssue.getTicketId().concat(":").concat(externalSystemIssue.getUrl())).collect(Collectors.joining(separator));
        }
        return "";
    }

    private List<Activity> processTestItemIssues(String projectName, String principal, Map<IssueDefinition, TestItem> data) {
        String emptyString = "";
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Project projectSettings = (Project)this.projectSettingsRepository.findOne((Serializable)((Object)projectName));
        Set<Map.Entry<IssueDefinition, TestItem>> entries = data.entrySet();
        for (Map.Entry<IssueDefinition, TestItem> entry : entries) {
            Activity.FieldValues fieldValues;
            String comment;
            IssueDefinition issueDefinition = entry.getKey();
            TestItem testItem = entry.getValue();
            TestItemIssue testItemIssue = testItem.getIssue();
            String oldIssueDescription = testItemIssue.getIssueDescription();
            boolean oldIgnoreAnalyzer = testItemIssue.isIgnoreAnalyzer();
            StatisticSubType statisticSubType = projectSettings.getConfiguration().getByLocator(issueDefinition.getIssue().getIssueType());
            String oldIssueType = projectSettings.getConfiguration().getByLocator(testItemIssue.getIssueType()).getLongName();
            String initialComment = issueDefinition.getIssue().getComment();
            String string = comment = null != initialComment ? initialComment.trim() : emptyString;
            if (null == oldIssueDescription) {
                oldIssueDescription = emptyString;
            }
            ActivityEventType type = issueDefinition.getIssue().getAutoAnalyzed() ? ActivityEventType.ANALYZE_ITEM : ActivityEventType.UPDATE_ITEM;
            Activity activity = new ActivityBuilder().addProjectRef(projectName).addLoggedObjectRef(issueDefinition.getId()).addObjectType(ActivityObjectType.TEST_ITEM).addObjectName(testItem.getName()).addActionType(type).addUserRef(principal).get();
            ArrayList history = Lists.newArrayList();
            if (!oldIssueDescription.equals(comment)) {
                fieldValues = EventHandlerUtil.createHistoryField((String)COMMENT, (String)oldIssueDescription, (String)comment);
                history.add(fieldValues);
            }
            if (!(statisticSubType == null || null != oldIssueType && oldIssueType.equalsIgnoreCase(statisticSubType.getLongName()))) {
                fieldValues = EventHandlerUtil.createHistoryField((String)ISSUE_TYPE, (String)oldIssueType, (String)statisticSubType.getLongName());
                history.add(fieldValues);
            }
            if (oldIgnoreAnalyzer != issueDefinition.getIssue().getIgnoreAnalyzer()) {
                Activity.FieldValues field = EventHandlerUtil.createHistoryField((String)IGNORE_ANALYZER, (String)String.valueOf(oldIgnoreAnalyzer), (String)String.valueOf(issueDefinition.getIssue().getIgnoreAnalyzer()));
                history.add(field);
            }
            if (history.isEmpty()) continue;
            activity.setHistory((List)history);
            activities.add(activity);
        }
        return activities;
    }
}

