/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.events.UserCreatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UserActivityHandler {
    private final ActivityRepository activityRepository;

    @Autowired
    public UserActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onUserCreated(UserCreatedEvent event) {
        Activity activity = new ActivityBuilder().addActionType(ActivityEventType.CREATE_USER).addLoggedObjectRef(event.getUser().getLogin()).addObjectName(event.getUser().getLogin()).addObjectType(ActivityObjectType.USER).addUserRef(event.getCreatedBy()).addProjectRef(event.getUser().getDefaultProject().toLowerCase()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)event.getUser().getLogin()))).get();
        this.activityRepository.save((Object)activity);
    }
}

