/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.events.WidgetCreatedEvent;
import com.epam.ta.reportportal.events.WidgetDeletedEvent;
import com.epam.ta.reportportal.events.WidgetUpdatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.widget.ContentParameters;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class WidgetActivityEventHandler {
    private static final String ITEMS_COUNT = "items_count";
    private static final String CONTENT_FIELDS = "content_fields";
    private static final String METADATA_FIELDS = "metadata_fields";
    private static final String WIDGET_OPTIONS = "widget_options";
    private ActivityRepository activityRepository;

    @Autowired
    public WidgetActivityEventHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onWidgetUpdated(WidgetUpdatedEvent event) {
        Widget widget = (Widget)event.getBefore();
        WidgetRQ widgetRQ = event.getWidgetRQ();
        ArrayList history = Lists.newArrayList();
        if (widget != null) {
            EventHandlerUtil.processShare((List)history, (Shareable)widget, (Boolean)widgetRQ.getShare());
            EventHandlerUtil.processName((List)history, (String)widget.getName(), (String)widgetRQ.getName());
            EventHandlerUtil.processDescription((List)history, (String)widget.getDescription(), (String)widgetRQ.getDescription());
            this.processContentParameters((List)history, widget.getContentOptions(), widgetRQ.getContentParameters());
            if (!history.isEmpty()) {
                Activity activityLog = new ActivityBuilder().addProjectRef(widget.getProjectName()).addObjectName(widget.getName()).addObjectType(ActivityObjectType.WIDGET).addActionType(ActivityEventType.UPDATE_WIDGET).addLoggedObjectRef(widget.getId()).addUserRef(event.getUpdatedBy()).addHistory((List)history).get();
                this.activityRepository.save((Object)activityLog);
            }
        }
    }

    @EventListener
    public void onCreateWidget(WidgetCreatedEvent event) {
        WidgetRQ widgetRQ = event.getWidgetRQ();
        Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.CREATE_WIDGET).addObjectType(ActivityObjectType.WIDGET).addObjectName(widgetRQ.getName()).addProjectRef(event.getProjectRef()).addUserRef(event.getCreatedBy()).addLoggedObjectRef(event.getWidgetId()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)widgetRQ.getName()))).get();
        this.activityRepository.save((Object)activityLog);
    }

    @EventListener
    public void onDeleteWidget(WidgetDeletedEvent event) {
        Widget widget = (Widget)event.getBefore();
        Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.DELETE_WIDGET).addObjectType(ActivityObjectType.WIDGET).addObjectName(widget.getName()).addProjectRef(widget.getProjectName()).addUserRef(event.getRemovedBy()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)widget.getName(), (String)""))).get();
        this.activityRepository.save((Object)activityLog);
    }

    private void processContentParameters(List<Activity.FieldValues> history, ContentOptions old, ContentParameters newContent) {
        this.processItemsCount(history, old.getItemsCount(), newContent.getItemsCount());
        this.processFields(history, old.getContentFields(), newContent.getContentFields(), CONTENT_FIELDS);
        this.processFields(history, old.getMetadataFields(), newContent.getMetadataFields(), METADATA_FIELDS);
        this.processWidgetOptions(history, old.getWidgetOptions(), newContent.getWidgetOptions());
    }

    private void processItemsCount(List<Activity.FieldValues> history, int oldItemsCount, int newItemsCount) {
        if (oldItemsCount != newItemsCount) {
            history.add(EventHandlerUtil.createHistoryField((String)ITEMS_COUNT, (String)String.valueOf(oldItemsCount), (String)String.valueOf(newItemsCount)));
        }
    }

    private void processWidgetOptions(List<Activity.FieldValues> history, Map<String, List<String>> oldOptions, Map<String, List<String>> newOptions) {
        if (null != oldOptions && null != newOptions && !oldOptions.equals(newOptions)) {
            String oldValue = oldOptions.entrySet().stream().map(it -> (String)it.getKey() + ":" + ((List)it.getValue()).toString()).collect(Collectors.joining(", "));
            String newValue = newOptions.entrySet().stream().map(it -> (String)it.getKey() + ":" + ((List)it.getValue()).toString()).collect(Collectors.joining(", "));
            history.add(EventHandlerUtil.createHistoryField((String)WIDGET_OPTIONS, (String)oldValue, (String)newValue));
        }
    }

    private void processFields(List<Activity.FieldValues> history, List<String> oldFields, List<String> newFields, String field) {
        if (null != oldFields && null != newFields && !oldFields.equals(newFields)) {
            String oldValue = oldFields.stream().collect(Collectors.joining(", "));
            String newValue = newFields.stream().collect(Collectors.joining(", "));
            history.add(EventHandlerUtil.createHistoryField((String)field, (String)oldValue, (String)newValue));
        }
    }
}

