/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import com.epam.ta.reportportal.job.PageUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CleanLogsJob
implements Job {
    public static final int DEFAULT_THREAD_COUNT = 5;
    public static final long JOB_EXECUTION_TIMEOUT = 1L;
    private static final Duration MIN_DELAY = Duration.ofDays(KeepLogsDelay.TWO_WEEKS.getDays() - 1L);
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLogsJob.class);
    @Autowired
    private LogRepository logRepo;
    @Autowired
    private LaunchRepository launchRepo;
    @Autowired
    private TestItemRepository testItemRepo;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    @Value(value="${com.ta.reportportal.job.clean.logs.threads:5}")
    private Integer threadsCount;

    public void execute(JobExecutionContext context) {
        LOGGER.debug("Cleaning outdated logs has been started");
        ExecutorService executor = Executors.newFixedThreadPool(Optional.ofNullable(this.threadsCount).orElse(5), new ThreadFactoryBuilder().setNameFormat("clean-logs-job-thread-%d").build());
        PageUtil.iterateOverPages(arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndConfiguration(arg_0), projects -> projects.forEach(project -> executor.submit(() -> {
            try {
                LOGGER.info("Cleaning outdated logs for project {} has been started", (Object)project.getId());
                Duration period = Duration.ofDays(KeepLogsDelay.findByName((String)project.getConfiguration().getKeepLogs()).getDays());
                if (!period.isZero()) {
                    this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
                    this.removeOutdatedLogs(project.getId(), period);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Cleaning outdated logs for project {} has been failed", (Object)project.getId(), (Object)e);
            }
            LOGGER.info("Cleaning outdated logs for project {} has been finished", (Object)project.getId());
        })));
        executor.shutdown();
        try {
            LOGGER.info("Awaiting cleaning outdated screenshot to finish");
            executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Job Execution timeout exceeded", e);
        }
    }

    private void removeOutdatedLogs(String projectId, Duration period) {
        Date endDate = Date.from(Instant.now().minusSeconds(MIN_DELAY.getSeconds()));
        AtomicLong countPerProject = new AtomicLong(0L);
        PageUtil.iterateOverPages(pageable -> this.launchRepo.findModifiedBefore(projectId, endDate, pageable), launches -> launches.forEach(launch -> {
            try (Stream testItemStream = this.testItemRepo.streamIdsByLaunch(launch.getId());){
                long count = this.logRepo.deleteByPeriodAndItemsRef(period, testItemStream.map(TestItem::getId).collect(Collectors.toList()));
                countPerProject.addAndGet(count);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        LOGGER.info("Removed {} logs for project {}", (Object)countPerProject.get(), (Object)projectId);
    }
}

