/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.migration;

import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

@ChangeLog(order="3.3")
public class ChangeSets_3_3 {
    private static final String HISTORY = "history";
    private static final String ID = "_id";
    private static final String COLLECTION = "activity";
    private static final String ACTION_TYPE = "actionType";

    @ChangeSet(order="3.3-1", id="v3.3-Replace activities embedded collection 'history' with array", author="pbortnik")
    public void replaceActivitesHistory(MongoTemplate mongoTemplate) {
        Query q = new Query((CriteriaDefinition)Criteria.where((String)HISTORY).exists(true));
        q.fields().include(ID).include(HISTORY);
        mongoTemplate.stream(q, DBObject.class, COLLECTION).forEachRemaining(dbo -> {
            DBObject history = (DBObject)dbo.get(HISTORY);
            Update u = new Update();
            LinkedHashMap[] dbArray = new LinkedHashMap[history.keySet().size()];
            int i = 0;
            for (String key : history.keySet()) {
                LinkedHashMap<String, String> res;
                DBObject o = (DBObject)history.get(key);
                if (null != o && null != o.keySet()) {
                    res = new LinkedHashMap(o.keySet().size() + 1);
                    res.put("field", key);
                    res.putAll(o.toMap());
                    dbArray[i] = res;
                    ++i;
                    continue;
                }
                res = new LinkedHashMap<String, String>(3);
                res.put("field", key);
                res.put("oldValue", "");
                res.put("newValue", "");
                dbArray[i] = res;
                ++i;
            }
            u.set(HISTORY, (Object)dbArray);
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)ID).is(dbo.get(ID))), u, COLLECTION);
        });
    }

    @ChangeSet(order="3.3-2", id="v3.3-Update activity types with new values", author="pbortnik")
    public void updateActivityTypes(MongoTemplate mongoTemplate) {
        Query q = new Query((CriteriaDefinition)Criteria.where((String)ACTION_TYPE).in(new Object[]{"start", "finish", "delete", "share", "unshare"}));
        mongoTemplate.stream(q, DBObject.class, COLLECTION).forEachRemaining(dbo -> {
            String type = (String)dbo.get(ACTION_TYPE);
            Update u = new Update();
            switch (type) {
                case "start": {
                    u.set(ACTION_TYPE, (Object)ActivityEventType.START_LAUNCH.getValue());
                    break;
                }
                case "finish": {
                    u.set(ACTION_TYPE, (Object)ActivityEventType.FINISH_LAUNCH.getValue());
                    break;
                }
                case "delete": {
                    u.set(ACTION_TYPE, (Object)ActivityEventType.DELETE_LAUNCH.getValue());
                    break;
                }
                case "share": {
                    u = this.createShareHistory(u, (String)dbo.get("objectType"), "true", "false");
                    break;
                }
                case "unshare": {
                    u = this.createShareHistory(u, (String)dbo.get("objectType"), "false", "true");
                }
            }
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)ID).is(dbo.get(ID))), u, COLLECTION);
        });
    }

    @ChangeSet(order="3.3-3", id="v3.3-Generate uniqueId for all test items based on md5 algorithm", author="pbortnik")
    public void generate(MongoTemplate mongoTemplate) {
        mongoTemplate.createCollection("generationCheckpoint");
    }

    @ChangeSet(order="3.3-4", id="V3.3-Drop unused failReferences collection in reason of new analyzer", author="pbortnik")
    public void dropfailReferences(MongoTemplate mongoTemplate) {
        mongoTemplate.dropCollection("failReferences");
    }

    private Update createShareHistory(Update u, String objectType, String oldValue, String newValue) {
        LinkedHashMap[] dbArray = new LinkedHashMap[1];
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(3);
        res.put("field", "share");
        res.put("oldValue", oldValue);
        res.put("newValue", newValue);
        dbArray[0] = res;
        u.set(HISTORY, (Object)dbArray);
        switch (objectType) {
            case "dashboard": {
                u.set(ACTION_TYPE, (Object)ActivityEventType.UPDATE_DASHBOARD.getValue());
                break;
            }
            case "widget": {
                u.set(ACTION_TYPE, (Object)ActivityEventType.UPDATE_WIDGET.getValue());
            }
        }
        return u;
    }
}

