/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.migration;

import com.epam.ta.reportportal.database.entity.AnalyzeMode;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

@ChangeLog(order="4.0")
public class ChangeSets_4_0 {
    @ChangeSet(order="4.0-1", id="v.4.0-Update refactored widgets", author="pbortnik")
    public void updateWidgets(MongoTemplate mongoTemplate) {
        String collection = "widget";
        Criteria criteria = new Criteria();
        Query query = Query.query((CriteriaDefinition)criteria.orOperator(new Criteria[]{Criteria.where((String)"contentOptions.type").is((Object)"line_chart").and("contentOptions.gadgetType").is((Object)"old_line_chart"), Criteria.where((String)"contentOptions.type").is((Object)"trends_chart").and("contentOptions.gadgetType").is((Object)"statistic_trend")}));
        query.fields().include("_id");
        query.fields().include("contentOptions");
        String[] viewMode = new String[1];
        mongoTemplate.stream(query, DBObject.class, "widget").forEachRemaining(widget -> {
            Update update = new Update();
            DBObject contentOptions = (DBObject)widget.get("contentOptions");
            BasicDBObject widgetOptions = (BasicDBObject)contentOptions.get("widgetOptions");
            String type = (String)contentOptions.get("type");
            update.set("contentOptions.type", (Object)"trends_chart");
            update.set("contentOptions.gadgetType", (Object)"statistic_trend");
            String string = viewMode[0] = "line_chart".equals(type) ? "areaChartMode" : "barMode";
            if (widgetOptions != null) {
                widgetOptions.append("viewMode", (Object)viewMode);
            } else {
                widgetOptions = new BasicDBObject("viewMode", (Object)viewMode);
            }
            update.set("contentOptions.widgetOptions", (Object)widgetOptions);
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(widget.get("_id"))), update, "widget");
        });
    }

    @ChangeSet(order="4.0-2", id="v.4.0-Update filter model", author="pbortnik")
    public void updateFilters(MongoTemplate mongoTemplate) {
        String collection = "userFilter";
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"selectionOptions").exists(true));
        q.fields().include("_id");
        q.fields().include("selectionOptions");
        mongoTemplate.stream(q, DBObject.class, "userFilter").forEachRemaining(filter -> {
            Update update = new Update();
            Map map = (Map)filter.get("selectionOptions");
            String sortingColumnName = (String)map.get("sortingColumnName");
            Boolean isAsc = (Boolean)map.get("isAsc");
            ArrayList selectionOrders = Lists.newArrayList((Object[])new BasicDBObject[]{new BasicDBObject("isAsc", (Object)isAsc).append("sortingColumnName", (Object)sortingColumnName)});
            if (sortingColumnName.equals("start_time")) {
                selectionOrders.add(new BasicDBObject("isAsc", (Object)isAsc).append("sortingColumnName", (Object)"number"));
            }
            update.set("selectionOptions", (Object)new BasicDBObject("pageNumber", map.get("pageNumber")).append("orders", (Object)selectionOrders));
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(filter.get("_id"))), update, "userFilter");
        });
    }

    @ChangeSet(order="4.0-3", id="v4.0-Add log indexing checkpoint ID", author="isharamet")
    public void addLogIndexingCheckpoint(MongoTemplate mongoTemplate) {
        mongoTemplate.createCollection("logIndexingCheckpoint");
    }

    @ChangeSet(order="4.0-4", id="v4.1-Update metadata project names to lower case", author="pbortnik")
    public void updateAttachmentsMetadata(MongoTemplate mongoTemplate) {
        String collection = "fs.files";
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"metadata.project").exists(true));
        q.fields().include("_id");
        q.fields().include("metadata.project");
        mongoTemplate.stream(q, DBObject.class, collection).forEachRemaining(o -> {
            Map metadata = (Map)o.get("metadata");
            String project = (String)metadata.get("project");
            if (null != project && !StringUtils.isAllLowerCase((CharSequence)project)) {
                String inLower = project.toLowerCase();
                Update update = new Update();
                update.set("metadata.project", (Object)inLower);
                mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(o.get("_id"))), update, collection);
            }
        });
    }

    @ChangeSet(order="4.2-1", id="v4.2-Update activities names", author="pbortnik")
    public void updateActivitiesNames(MongoTemplate mongoTemplate) {
        String collection = "activity";
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"actionType").in((Collection)Lists.newArrayList((Object[])new String[]{"load_issue", "load_issue_aa", "attach_issue", "attach_issue_aa"})));
        q.fields().include("_id");
        q.fields().include("actionType");
        mongoTemplate.stream(q, DBObject.class, collection).forEachRemaining(o -> {
            String type = (String)o.get("actionType");
            Update u = new Update();
            if ("load_issue".equals(type) || "attach_issue".equals(type)) {
                u.set("actionType", (Object)"link_issue");
            } else if ("load_issue_aa".equals(type) || "attach_issue_aa".equals(type)) {
                u.set("actionType", (Object)"link_issue_aa");
            }
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(o.get("_id"))), u, collection);
        });
    }

    @ChangeSet(order="4.2-2", id="v4.2-Introduce default analyzer parameters for each project", author="pbortnik")
    public void introduceAnalyzerParameters(MongoTemplate mongoTemplate) {
        String collection = "project";
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"configuration").exists(true).and("configuration.analyzerConfig").exists(false));
        query.fields().include("_id");
        query.fields().include("configuration");
        mongoTemplate.stream(query, DBObject.class, collection).forEachRemaining(p -> {
            BasicDBObject configuration = (BasicDBObject)p.get("configuration");
            Boolean isAAEnabled = (Boolean)Optional.ofNullable(configuration.get("isAutoAnalyzerEnabled")).orElse(false);
            String analyzerMode = configuration.get("analyzerMode") != null ? AnalyzeMode.valueOf((String)((String)configuration.get("analyzerMode"))).getValue() : AnalyzeMode.BY_LAUNCH_NAME.getValue();
            Update update = new Update();
            update.unset("configuration.isAutoAnalyzerEnabled");
            update.unset("configuration.analyzerMode");
            update.set("configuration.analyzerConfig.minDocFreq", (Object)7);
            update.set("configuration.analyzerConfig.minTermFreq", (Object)1);
            update.set("configuration.analyzerConfig.minShouldMatch", (Object)80);
            update.set("configuration.analyzerConfig.numberOfLogLines", (Object)2);
            update.set("configuration.analyzerConfig.isAutoAnalyzerEnabled", (Object)isAAEnabled);
            update.set("configuration.analyzerConfig.analyzerMode", (Object)analyzerMode);
            mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(p.get("_id"))), update, collection);
        });
    }
}

