/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.user.ICreateUserHandler;
import com.epam.ta.reportportal.core.user.IDeleteUserHandler;
import com.epam.ta.reportportal.core.user.IEditUserHandler;
import com.epam.ta.reportportal.core.user.IGetUserHandler;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.controller.IUserController;
import com.epam.ta.reportportal.ws.model.ModelViews;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.user.ChangePasswordRQ;
import com.epam.ta.reportportal.ws.model.user.CreateUserBidRS;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQ;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.ws.model.user.CreateUserRS;
import com.epam.ta.reportportal.ws.model.user.EditUserRQ;
import com.epam.ta.reportportal.ws.model.user.ResetPasswordRQ;
import com.epam.ta.reportportal.ws.model.user.RestorePasswordRQ;
import com.epam.ta.reportportal.ws.model.user.UserBidRS;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.epam.ta.reportportal.ws.resolver.ActiveRole;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.ResponseView;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/user"})
public class UserController
implements IUserController {
    @Autowired
    private ICreateUserHandler createUserMessageHandler;
    @Autowired
    private IEditUserHandler editUserMessageHandler;
    @Autowired
    private IDeleteUserHandler deleteUserMessageHandler;
    @Autowired
    private IGetUserHandler getUserHandler;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Create specified user", notes="Allowable only for users with administrator role")
    public CreateUserRS createUserByAdmin(@RequestBody @Validated CreateUserRQFull rq, Principal principal, HttpServletRequest request) {
        String basicURL = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replacePath(null).replaceQuery(null).build().toUriString();
        return this.createUserMessageHandler.createUserByAdmin(rq, principal.getName(), basicURL);
    }

    @RequestMapping(value={"/bid"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#createUserRQ.getDefaultProject(), 'projectManagerPermission')")
    @ApiOperation(value="Register invitation for user who will be created")
    public CreateUserBidRS createUserBid(@RequestBody @Validated CreateUserRQ createUserRQ, Principal principal, HttpServletRequest request) {
        URI rqUrl = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replacePath(null).replaceQuery(null).build().toUri();
        return this.createUserMessageHandler.createUserBid(createUserRQ, principal, rqUrl.toASCIIString());
    }

    @RequestMapping(value={"/registration"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @ApiOperation(value="Activate invitation and create user in system")
    public CreateUserRS createUser(@RequestBody @Validated CreateUserRQConfirm request, @RequestParam(value="uuid") String uuid, Principal principal) {
        return this.createUserMessageHandler.createUser(request, uuid, principal);
    }

    @RequestMapping(value={"/registration"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiIgnore
    public UserBidRS getUserBidInfo(@RequestParam(value="uuid") String uuid) {
        return this.getUserHandler.getBidInformation(uuid);
    }

    @RequestMapping(value={"/{login}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Delete specified user", notes="Allowable only for users with administrator role")
    public OperationCompletionRS deleteUser(@PathVariable String login, Principal principal) {
        return this.deleteUserMessageHandler.deleteUser(EntityUtils.normalizeId((String)login), principal.getName());
    }

    @RequestMapping(value={"/{login}"}, method={RequestMethod.PUT})
    @ResponseBody
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Edit specified user", notes="Only for administrators and profile's owner")
    public OperationCompletionRS editUser(@PathVariable String login, @RequestBody @Validated EditUserRQ editUserRQ, @ActiveRole UserRole role, Principal principal) {
        return this.editUserMessageHandler.editUser(EntityUtils.normalizeId((String)login), editUserRQ, role);
    }

    @RequestMapping(value={"/{login}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseView(value=ModelViews.FullUserView.class)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Return information about specified user", notes="Only for administrators and profile's owner")
    public UserResource getUser(@PathVariable String login, Principal principal) {
        return this.getUserHandler.getUser(EntityUtils.normalizeId((String)login), principal);
    }

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseView(value=ModelViews.FullUserView.class)
    @ApiOperation(value="Return information about current logged-in user")
    public UserResource getMyself(Principal principal) {
        return this.getUserHandler.getUser(EntityUtils.normalizeId((String)principal.getName()), principal);
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseView(value=ModelViews.FullUserView.class)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Return information about all users", notes="Allowable only for users with administrator role")
    public Iterable<UserResource> getUsers(@FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, Principal principal) {
        return this.getUserHandler.getAllUsers(filter, pageable);
    }

    @RequestMapping(value={"/registration/info"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiIgnore
    public YesNoRS validateInfo(@RequestParam(value="username", required=false) String username, @RequestParam(value="email", required=false) String email) {
        return this.getUserHandler.validateInfo(username, email);
    }

    @RequestMapping(value={"/password/restore"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Create a restore password request")
    public OperationCompletionRS restorePassword(@RequestBody @Validated RestorePasswordRQ rq, HttpServletRequest request) {
        String baseUrl = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).replacePath(null).replaceQuery(null).build().toUriString();
        return this.createUserMessageHandler.createRestorePasswordBid(rq, baseUrl);
    }

    @RequestMapping(value={"/password/reset"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Reset password")
    public OperationCompletionRS resetPassword(@RequestBody @Validated ResetPasswordRQ rq) {
        return this.createUserMessageHandler.resetPassword(rq);
    }

    @RequestMapping(value={"/password/reset/{id}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Check if a restore password bid exists")
    public YesNoRS isRestorePasswordBidExist(@PathVariable String id) {
        return this.createUserMessageHandler.isResetPasswordBidExist(id);
    }

    @RequestMapping(value={"/password/change"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Change own password")
    public OperationCompletionRS changePassword(@RequestBody @Validated ChangePasswordRQ changePasswordRQ, Principal principal) {
        return this.editUserMessageHandler.changePassword(principal.getName(), changePasswordRQ);
    }

    @RequestMapping(value={"/{userName}/projects"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiIgnore
    public Map<String, UserResource.AssignedProject> getUserProjects(@PathVariable String userName, Principal principal) {
        return this.getUserHandler.getUserProjects(userName);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiIgnore
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public Iterable<UserResource> findUsers(@RequestParam(value="term") String term, Pageable pageable, Principal principal) {
        return this.getUserHandler.searchUsers(term, pageable);
    }
}

