/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQConfirm;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Calendar;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class UserBuilder
extends Builder<User> {
    private static final HashFunction HASH_FUNCTION = Hashing.md5();

    public UserBuilder addCreateUserRQ(CreateUserRQConfirm request) {
        if (request != null) {
            User user = (User)this.getObject();
            user.setLogin(EntityUtils.normalizeId((String)request.getLogin()));
            user.setPassword(HASH_FUNCTION.hashString((CharSequence)request.getPassword(), Charsets.UTF_8).toString());
            user.setEmail(EntityUtils.normalizeId((String)request.getEmail().trim()));
            user.setDefaultProject(EntityUtils.normalizeId((String)request.getDefaultProject()));
            user.setFullName(request.getFullName());
            user.setType(UserType.INTERNAL);
            user.setIsExpired(false);
            user.getMetaInfo().setLastLogin(Calendar.getInstance().getTime());
        }
        return this;
    }

    public UserBuilder addUserRole(UserRole userRole) {
        ((User)this.getObject()).setRole(userRole);
        return this;
    }

    protected User initObject() {
        return new User();
    }
}

