/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class UserResourceBuilder
extends Builder<UserResource> {
    @Autowired
    private ProjectRepository projectRepository;
    private static Comparator<Project> PROJECT_NAME_ALPHABET = (prj1, prj2) -> {
        int res = String.CASE_INSENSITIVE_ORDER.compare(prj1.getName(), prj2.getName());
        if (res == 0) {
            res = prj1.getName().compareTo(prj2.getName());
        }
        return res;
    };

    public UserResourceBuilder addUser(User user) {
        if (null != user) {
            return this.addUser(user, this.projectRepository.findUserProjects(user.getLogin()));
        }
        return this;
    }

    private UserResourceBuilder addUser(User user, List<Project> projects) {
        if (user != null) {
            UserResource resource = (UserResource)this.getObject();
            resource.setUserId(user.getLogin());
            resource.setEmail(user.getEmail());
            resource.setPhotoId(user.getPhotoId());
            resource.setFullName(user.getFullName());
            Optional.ofNullable(user.getType()).ifPresent(type -> resource.setAccountType(type.toString()));
            Optional.ofNullable(user.getRole()).ifPresent(role -> resource.setUserRole(role.toString()));
            Optional.ofNullable(user.getMetaInfo()).ifPresent(meta -> resource.setLastlogin(meta.getLastLogin()));
            resource.setIsLoaded(UserType.UPSA != user.getType());
            if (null != projects) {
                if (projects.size() > 1) {
                    projects.sort(PROJECT_NAME_ALPHABET);
                }
                LinkedHashMap<String, UserResource.AssignedProject> userProjects = new LinkedHashMap<String, UserResource.AssignedProject>(projects.size());
                String personalProject = null;
                for (Project project : projects) {
                    UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
                    Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)user.getId());
                    Optional.ofNullable(userConfig.getProjectRole()).ifPresent(it -> assignedProject.setProjectRole(it.name()));
                    Optional.ofNullable(userConfig.getProposedRole()).ifPresent(it -> assignedProject.setProposedRole(it.name()));
                    assignedProject.setEntryType(project.getConfiguration().getEntryType().name());
                    userProjects.put(project.getId(), assignedProject);
                    if (!EntryType.PERSONAL.equals((Object)project.getConfiguration().getEntryType())) continue;
                    personalProject = project.getId();
                }
                resource.setAssignedProjects(userProjects);
                if (userProjects.containsKey(user.getDefaultProject())) {
                    resource.setDefaultProject(user.getDefaultProject());
                } else {
                    resource.setDefaultProject(personalProject);
                }
            }
        }
        return this;
    }

    protected UserResource initObject() {
        return new UserResource();
    }
}

