/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.project.email.EmailSenderCase;
import com.epam.ta.reportportal.database.entity.project.email.ProjectEmailConfig;
import com.epam.ta.reportportal.ws.model.project.email.EmailSenderCaseDTO;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfigDTO;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class EmailConfigConverters {
    public static final Function<ProjectEmailConfigDTO, ProjectEmailConfig> TO_MODEL = resource -> {
        Preconditions.checkNotNull((Object)resource);
        ProjectEmailConfig db = new ProjectEmailConfig();
        db.setEmailCases(Optional.ofNullable(resource.getEmailCases()).orElseGet(Collections::emptyList).stream().map(TO_CASE_MODEL).collect(Collectors.toList()));
        db.setEmailEnabled(resource.getEmailEnabled());
        db.setFrom(resource.getFrom());
        return db;
    };
    public static final Function<ProjectEmailConfig, ProjectEmailConfigDTO> TO_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        ProjectEmailConfigDTO resource = new ProjectEmailConfigDTO();
        resource.setEmailCases(Optional.ofNullable(model.getEmailCases()).orElseGet(Collections::emptyList).stream().map(TO_CASE_RESOURCE).collect(Collectors.toList()));
        resource.setEmailEnabled(model.getEmailEnabled().booleanValue());
        resource.setFrom(model.getFrom());
        return resource;
    };
    public static final Function<EmailSenderCaseDTO, EmailSenderCase> TO_CASE_MODEL = resource -> {
        Preconditions.checkNotNull((Object)resource);
        EmailSenderCase db = new EmailSenderCase();
        db.setLaunchNames(resource.getLaunchNames());
        db.setRecipients(resource.getRecipients());
        db.setSendCase(resource.getSendCase());
        db.setTags(resource.getTags());
        return db;
    };
    private static final Function<EmailSenderCase, EmailSenderCaseDTO> TO_CASE_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        EmailSenderCaseDTO resource = new EmailSenderCaseDTO();
        resource.setLaunchNames(model.getLaunchNames());
        resource.setTags(model.getTags());
        resource.setSendCase(model.getSendCase());
        resource.setRecipients(model.getRecipients());
        return resource;
    };

    private EmailConfigConverters() {
    }
}

