/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.filter.SelectionOrder;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.filter.Order;
import com.epam.ta.reportportal.ws.model.filter.SelectionParameters;
import com.epam.ta.reportportal.ws.model.filter.UserFilterEntity;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class UserFilterConverter {
    public static final Function<UserFilter, UserFilterResource> TO_RESOURCE = filter -> {
        Preconditions.checkNotNull((Object)filter);
        UserFilterResource resource = new UserFilterResource();
        resource.setFilterId(filter.getId());
        resource.setName(filter.getName());
        resource.setDescription(filter.getDescription());
        Optional.ofNullable(filter.getFilter()).ifPresent(f -> {
            resource.setObjectType(f.getTarget().getSimpleName().toLowerCase());
            resource.setEntities((Set)TO_ENTITIES.apply(f));
        });
        Optional.ofNullable(filter.getSelectionOptions()).ifPresent(it -> resource.setSelectionParameters((SelectionParameters)TO_SELECTION_PARAMETERS.apply(it)));
        Optional.ofNullable(filter.getAcl()).ifPresent(acl -> {
            resource.setOwner(acl.getOwnerUserId());
            resource.setShare(!acl.getEntries().isEmpty());
        });
        return resource;
    };
    public static final Function<SelectionParameters, SelectionOptions> TO_SELECTION_OPTIONS = parameters -> {
        Preconditions.checkNotNull((Object)parameters);
        Preconditions.checkNotNull((Object)parameters.getOrders());
        SelectionOptions selectionOptions = new SelectionOptions();
        selectionOptions.setPageNumber(parameters.getPageNumber());
        selectionOptions.setOrders(parameters.getOrders().stream().map(order -> {
            SelectionOrder selectionOrder = new SelectionOrder();
            selectionOrder.setIsAsc(order.getIsAsc());
            selectionOrder.setSortingColumnName(order.getSortingColumnName());
            return selectionOrder;
        }).collect(Collectors.toList()));
        return selectionOptions;
    };
    public static final Function<SelectionOptions, SelectionParameters> TO_SELECTION_PARAMETERS = options -> {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)options.getOrders());
        SelectionParameters selectionParameters = new SelectionParameters();
        selectionParameters.setPageNumber(options.getPageNumber());
        selectionParameters.setOrders(options.getOrders().stream().map(selectionOrder -> {
            Order order = new Order();
            order.setIsAsc(selectionOrder.isAsc());
            order.setSortingColumnName(selectionOrder.getSortingColumnName());
            return order;
        }).collect(Collectors.toList()));
        return selectionParameters;
    };
    private static final Function<Filter, Set<UserFilterEntity>> TO_ENTITIES = filter -> {
        LinkedHashSet result = Sets.newLinkedHashSet();
        filter.getFilterConditions().forEach(condition -> {
            UserFilterEntity userFilterEntity = new UserFilterEntity();
            Optional.ofNullable(condition.getCondition().getMarker()).map(it -> Condition.makeNegative((boolean)condition.isNegative(), (String)it)).ifPresent(arg_0 -> ((UserFilterEntity)userFilterEntity).setCondition(arg_0));
            userFilterEntity.setValue(condition.getValue());
            userFilterEntity.setFilteringField(condition.getSearchCriteria());
            result.add(userFilterEntity);
        });
        return result;
    };

    private UserFilterConverter() {
    }
}

