/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.impl;

import com.epam.ta.reportportal.core.analyzer.model.IndexLog;
import com.epam.ta.reportportal.core.analyzer.model.IndexTestItem;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AnalyzerUtils {
    private static Function<Log, IndexLog> TO_INDEX_LOG = log -> {
        IndexLog indexLog = new IndexLog();
        indexLog.setLogId(log.getId());
        if (log.getLevel() != null) {
            indexLog.setLogLevel(log.getLevel().toInt());
        }
        indexLog.setMessage(log.getLogMsg());
        return indexLog;
    };

    private AnalyzerUtils() {
    }

    public static IndexTestItem fromTestItem(TestItem testItem, List<Log> logs) {
        IndexTestItem indexTestItem = new IndexTestItem();
        indexTestItem.setTestItemId(testItem.getId());
        indexTestItem.setUniqueId(testItem.getUniqueId());
        if (testItem.getIssue() != null) {
            indexTestItem.setIssueType(testItem.getIssue().getIssueType());
            indexTestItem.setAutoAnalyzed(testItem.getIssue().isAutoAnalyzed());
        }
        if (!logs.isEmpty()) {
            indexTestItem.setLogs(logs.stream().map(TO_INDEX_LOG).collect(Collectors.toSet()));
        }
        return indexTestItem;
    }
}

