/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.impl;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.analyzer.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.model.IndexLaunch;
import com.epam.ta.reportportal.core.analyzer.model.IndexRs;
import com.epam.ta.reportportal.core.analyzer.model.IndexTestItem;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.AnalyzerConfigConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.util.CloseableIterator;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.TimeoutRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Service;

@Service(value="indexerService")
public class LogIndexerService
implements ILogIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogIndexerService.class);
    public static final int BATCH_SIZE = 1000;
    private static final String CHECKPOINT_COLL = "logIndexingCheckpoint";
    private static final String CHECKPOINT_ID = "checkpoint";
    private static final String CHECKPOINT_LOG_ID = "logId";
    private static final String LOG_LEVEL = "level.log_level";
    private static final String TEST_ITEM_REF = "testItemRef";
    private static final int MAX_TIMEOUT = 120000;
    @Autowired
    private AnalyzerServiceClient analyzerServiceClient;
    @Autowired
    private MongoOperations mongoOperations;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private MailServiceFactory mailServiceFactory;
    private ThreadLocal<Long> indexedLogsCount = ThreadLocal.withInitial(() -> 0L);
    private RetryTemplate retrier = new RetryTemplate();

    public LogIndexerService() {
        TimeoutRetryPolicy timeoutRetryPolicy = new TimeoutRetryPolicy();
        timeoutRetryPolicy.setTimeout(TimeUnit.SECONDS.toMillis(180L));
        this.retrier.setRetryPolicy((RetryPolicy)timeoutRetryPolicy);
        this.retrier.setBackOffPolicy((BackOffPolicy)new FixedBackOffPolicy());
        this.retrier.setThrowLastExceptionOnExhausted(true);
    }

    @VisibleForTesting
    protected void setRetrier(RetryTemplate retrier) {
        this.retrier = retrier;
    }

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.mongoOperations.collectionExists(CHECKPOINT_COLL)) {
            Executors.newSingleThreadExecutor().execute(() -> this.indexAllLogs());
        }
    }

    public void indexLog(Log log) {
        IndexLaunch rq = this.createRqLaunch(log);
        if (rq != null) {
            List rs = this.analyzerServiceClient.index(Collections.singletonList(rq));
            this.retryFailed(rs);
        }
    }

    public Long indexLogs(String launchId, List<TestItem> testItems) {
        List rqTestItems;
        Long indexedLogs = 0L;
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        if (Predicates.LAUNCH_CAN_BE_INDEXED.test(launch) && !CollectionUtils.isEmpty((Collection)(rqTestItems = this.prepareItemsForIndexing(testItems)))) {
            IndexLaunch rqLaunch = new IndexLaunch();
            rqLaunch.setLaunchId(launchId);
            rqLaunch.setLaunchName(launch.getName());
            rqLaunch.setProject(launch.getProjectRef());
            rqLaunch.setAnalyzerConfig((AnalyzerConfig)AnalyzerConfigConverter.TO_RESOURCE.apply(((Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()))).getConfiguration().getAnalyzerConfig()));
            rqLaunch.setTestItems(rqTestItems);
            List rs = this.analyzerServiceClient.index(Collections.singletonList(rqLaunch));
            indexedLogs = rs.stream().mapToLong(i -> i.getItems().size()).sum();
            this.retryFailed(rs);
        }
        return indexedLogs;
    }

    public void deleteIndex(String project) {
        this.analyzerServiceClient.deleteIndex(project);
    }

    public void cleanIndex(String index, List<String> ids) {
        List logIds = this.logRepository.findGreaterOrEqualLevel(ids, LogLevel.ERROR).stream().map(Log::getId).collect(Collectors.toList());
        this.analyzerServiceClient.cleanIndex(index, logIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexProjectData(Project project, User user) {
        try {
            List<String> launchIds = this.launchRepository.findLaunchIdsByProjectId(project.getId()).stream().map(Launch::getId).collect(Collectors.toList());
            launchIds.forEach(id -> {
                List items = this.testItemRepository.findItemsNotInIssueType(TestItemIssueType.TO_INVESTIGATE.getLocator(), id);
                Long indexedItemsPerLaunch = this.indexLogs(id, items);
                this.indexedLogsCount.set((Long)this.indexedLogsCount.get() + indexedItemsPerLaunch);
            });
            this.mailServiceFactory.getDefaultEmailService(true).sendIndexFinishedEmail("Index generation has been finished", user.getEmail(), (Long)this.indexedLogsCount.get());
        }
        finally {
            this.projectRepository.enableProjectIndexing(project.getName(), false);
        }
    }

    public void indexAllLogs() {
        this.retrier.execute(context -> {
            boolean hasClients = this.analyzerServiceClient.hasClients();
            LOGGER.info("Checking for analyzer clients availability to start logs indexing.");
            BusinessRule.expect((Object)hasClients, Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{"There are no analyzer's clients."});
            return hasClients;
        });
        String checkpoint = this.getLastCheckpoint(this.mongoOperations.getCollection(CHECKPOINT_COLL));
        try (CloseableIterator logIterator = this.mongoOperations.stream(this.getLogQuery(checkpoint), Log.class);){
            ArrayList<IndexLaunch> rq = new ArrayList<IndexLaunch>(1000);
            while (logIterator.hasNext()) {
                Log log = (Log)logIterator.next();
                IndexLaunch rqLaunch = this.createRqLaunch(log);
                if (rqLaunch == null) continue;
                if (checkpoint == null) {
                    checkpoint = log.getId();
                }
                rqLaunch.getTestItems().forEach(it -> it.setAutoAnalyzed(true));
                rq.add(rqLaunch);
                if (rq.size() != 1000 && logIterator.hasNext()) continue;
                this.createCheckpoint(this.mongoOperations.getCollection(CHECKPOINT_COLL), checkpoint);
                List rs = this.analyzerServiceClient.index(rq);
                this.retryFailed(rs);
                rq = new ArrayList(1000);
                checkpoint = null;
            }
            if (!CollectionUtils.isEmpty(rq)) {
                this.analyzerServiceClient.index(rq);
            }
        }
        this.mongoOperations.getCollection(CHECKPOINT_COLL).drop();
    }

    private IndexLaunch createRqLaunch(Log log) {
        Launch launch;
        if (!this.isLevelSuitable(log)) {
            return null;
        }
        IndexLaunch rqLaunch = null;
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)log.getTestItemRef()));
        if (Predicates.ITEM_CAN_BE_INDEXED.test(testItem) && Predicates.LAUNCH_CAN_BE_INDEXED.test(launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef())))) {
            rqLaunch = new IndexLaunch();
            rqLaunch.setLaunchId(launch.getId());
            rqLaunch.setLaunchName(launch.getName());
            rqLaunch.setProject(launch.getProjectRef());
            rqLaunch.setTestItems(Collections.singletonList(AnalyzerUtils.fromTestItem((TestItem)testItem, Collections.singletonList(log))));
        }
        return rqLaunch;
    }

    private List<IndexTestItem> prepareItemsForIndexing(List<TestItem> testItems) {
        return testItems.stream().filter(Predicates.ITEM_CAN_BE_INDEXED).map(it -> AnalyzerUtils.fromTestItem((TestItem)it, (List)this.logRepository.findGreaterOrEqualLevel(Collections.singletonList(it.getId()), LogLevel.ERROR))).filter(it -> !CollectionUtils.isEmpty((Collection)it.getLogs())).collect(Collectors.toList());
    }

    private boolean isLevelSuitable(Log log) {
        return null != log && null != log.getLevel() && log.getLevel().isGreaterOrEqual(LogLevel.ERROR);
    }

    private void retryFailed(List<IndexRs> rs) {
    }

    private Query getLogQuery(String checkpoint) {
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "_id")});
        Query query = new Query().with(sort).addCriteria((CriteriaDefinition)Criteria.where((String)LOG_LEVEL).gte((Object)40000)).noCursorTimeout().maxTimeMsec(120000L);
        if (checkpoint != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").gte((Object)new ObjectId(checkpoint)));
        }
        return query;
    }

    private String getLastCheckpoint(DBCollection dbCollection) {
        DBObject checkpoint = dbCollection.findOne((DBObject)new BasicDBObject("_id", (Object)CHECKPOINT_ID));
        return checkpoint == null ? null : (String)checkpoint.get(CHECKPOINT_LOG_ID);
    }

    private void createCheckpoint(DBCollection dbCollection, String logId) {
        BasicDBObject checkpoint = new BasicDBObject("_id", (Object)CHECKPOINT_ID).append(CHECKPOINT_LOG_ID, (Object)logId);
        dbCollection.save((DBObject)checkpoint);
    }
}

