/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.TestItemResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
class GetTestItemHandlerImpl
implements GetTestItemHandler {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final TestItemResourceAssembler itemAssembler;

    public GetTestItemHandlerImpl(LaunchRepository launchRepository, TestItemRepository testItemRepository, TestItemResourceAssembler itemAssembler) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.itemAssembler = itemAssembler;
    }

    public TestItemResource getTestItem(String testItemId) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId});
        return this.itemAssembler.toResource(testItem);
    }

    public Iterable<TestItemResource> getTestItems(Queryable filterable, Pageable pageable, String launchId, String projectName) {
        this.validate(launchId, projectName);
        return this.itemAssembler.toPagedResources(this.testItemRepository.findByFilter(filterable, pageable));
    }

    public List<String> getTags(String launchId, String value) {
        return this.testItemRepository.findDistinctValues(launchId, value, "tags");
    }

    public List<TestItemResource> getTestItems(String[] ids) {
        Iterable testItems = this.testItemRepository.findAll(Arrays.asList(ids));
        return this.itemAssembler.toResources(testItems);
    }

    private void validate(String launchId, String projectName) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Specified launch with id '{}' not referenced to specified project '{}'", (Object[])new Object[]{launch.getId(), projectName})});
    }
}

