/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.merge;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.item.merge.MergeTestItemHandler;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategy;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategyFactory;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.item.MergeTestItemRQ;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MergeTestItemHandlerImpl
implements MergeTestItemHandler {
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private MergeStrategyFactory mergeStrategyFactory;

    public OperationCompletionRS mergeTestItem(String projectName, String item, MergeTestItemRQ rq, String userName) {
        TestItem testItemTarget = this.validateTestItem(item);
        this.validateTestItemIsSuite(testItemTarget);
        Launch launchTarget = this.validateLaunch(testItemTarget.getLaunchRef());
        Project project = this.validateProject(launchTarget.getProjectRef());
        this.validateLaunchInProject(launchTarget, project);
        ArrayList<TestItem> itemsToMerge = new ArrayList<TestItem>(rq.getItems().size());
        HashSet<String> sourceLaunches = new HashSet<String>();
        for (String id : rq.getItems()) {
            TestItem itemToMerge = this.validateTestItem(id);
            sourceLaunches.add(itemToMerge.getLaunchRef());
            this.validateTestItemIsSuite(itemToMerge);
            this.validateTestItemInProject(itemToMerge, project);
            itemsToMerge.add(itemToMerge);
        }
        MergeStrategyType mergeStrategyType = MergeStrategyType.fromValue((String)rq.getMergeStrategyType());
        BusinessRule.expect((Object)mergeStrategyType, (Predicate)Predicates.notNull()).verify(ErrorType.UNSUPPORTED_MERGE_STRATEGY_TYPE, new Object[]{rq.getMergeStrategyType()});
        MergeStrategy mergeStrategy = this.mergeStrategyFactory.getStrategy(mergeStrategyType);
        mergeStrategy.mergeTestItems(testItemTarget, itemsToMerge);
        StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy());
        for (String launchID : sourceLaunches) {
            Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchID));
            statisticsFacade.recalculateStatistics(launch);
        }
        statisticsFacade.recalculateStatistics(launchTarget);
        return new OperationCompletionRS("TestItem with ID = '" + item + "' successfully merged.");
    }

    private void validateLaunchInProject(Launch launch, Project project) {
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)project.getId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
    }

    private void validateTestItemInProject(TestItem testItem, Project project) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)project.getId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
    }

    private TestItem validateTestItem(String testItemId) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId});
        return testItem;
    }

    private Launch validateLaunch(String launchId) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        return launch;
    }

    private Project validateProject(String projectId) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectId));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId});
        return project;
    }

    private void validateTestItemIsSuite(TestItem testItem) {
        BusinessRule.expect((Object)true, (Predicate)Predicates.equalTo((Object)testItem.getType().sameLevel(TestItemType.SUITE))).verify(ErrorType.INCORRECT_REQUEST, new Object[]{testItem.getId()});
    }
}

