/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper;

import com.epam.ta.reportportal.core.imprt.impl.DateUtils;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import java.time.Duration;
import java.util.Date;

public class TestItemPojo {
    private String type;
    private String name;
    private String status;
    private Double duration;
    private Integer total;
    private Integer passed;
    private Integer failed;
    private Integer skipped;
    private Integer automationBug;
    private Integer productBug;
    private Integer systemIssue;
    private Integer noDefect;
    private Integer toInvestigate;

    public TestItemPojo(TestItem input) {
        TestItemIssue issue;
        this.type = input.getType().name();
        String issueDescription = "";
        if (input.getIssue() != null && (issue = input.getIssue()).getIssueDescription() != null) {
            issueDescription = "\r\n DEFECT COMMENT: " + issue.getIssueDescription();
        }
        String description = "";
        if (input.getItemDescription() != null) {
            description = "\r\n ITEM DESCRIPTION: " + input.getItemDescription();
        }
        this.name = input.getName() + description + issueDescription;
        this.status = input.getStatus().name();
        this.duration = (double)Duration.between(DateUtils.fromDate((Date)input.getStartTime()), DateUtils.fromDate((Date)input.getEndTime())).toMillis() / 1000.0;
        ExecutionCounter exec = input.getStatistics().getExecutionCounter();
        this.total = exec.getTotal();
        this.passed = exec.getPassed();
        this.failed = exec.getFailed();
        this.skipped = exec.getSkipped();
        IssueCounter issue2 = input.getStatistics().getIssueCounter();
        this.automationBug = issue2.getAutomationBugTotal();
        this.productBug = issue2.getProductBugTotal();
        this.systemIssue = issue2.getSystemIssueTotal();
        this.noDefect = issue2.getNoDefectTotal();
        this.toInvestigate = issue2.getToInvestigateTotal();
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setStatus(String value) {
        this.status = value;
    }

    public String getStatus() {
        return this.status;
    }

    public void setTotal(Integer value) {
        this.total = value;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setPased(Integer value) {
        this.passed = value;
    }

    public Integer getPassed() {
        return this.passed;
    }

    public void setFailed(Integer value) {
        this.failed = value;
    }

    public Integer getFailed() {
        return this.failed;
    }

    public void setSkipped(Integer value) {
        this.skipped = value;
    }

    public Integer getSkipped() {
        return this.skipped;
    }

    public void setAutomationBug(Integer value) {
        this.automationBug = value;
    }

    public Integer getAutomationBug() {
        return this.automationBug;
    }

    public void setProductBug(Integer value) {
        this.productBug = value;
    }

    public Integer getProductBug() {
        return this.productBug;
    }

    public void setSystemIssue(Integer value) {
        this.systemIssue = value;
    }

    public Integer getSystemIssue() {
        return this.systemIssue;
    }

    public void setNoDefect(Integer value) {
        this.noDefect = value;
    }

    public Integer getNoDefect() {
        return this.noDefect;
    }

    public void setToInvestigate(Integer value) {
        this.toInvestigate = value;
    }

    public Integer getToInvestigate() {
        return this.toInvestigate;
    }

    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public void setPassed(Integer passed) {
        this.passed = passed;
    }

    public String toString() {
        return "TestItemPojo [type=" + this.type + ", name=" + this.name + ", status=" + this.status + ", total=" + this.total + ", passed=" + this.passed + ", failed=" + this.failed + ", skipped=" + this.skipped + ", automationBug=" + this.automationBug + ", productBug=" + this.productBug + ", systemIssue=" + this.systemIssue + ", noDefect=" + this.noDefect + ", toInvestigate=" + this.toInvestigate + "]";
    }
}

