/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.settings.ICreateProjectSettingsHandler;
import com.epam.ta.reportportal.core.widget.content.WidgetDataTypes;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.events.DefectTypeCreatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.config.CreateIssueSubTypeRQ;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CreateProjectSettingsHandler
implements ICreateProjectSettingsHandler {
    private static final Map<String, String> PREFIX = ImmutableMap.builder().put((Object)TestItemIssueType.AUTOMATION_BUG.getValue(), (Object)"ab_").put((Object)TestItemIssueType.PRODUCT_BUG.getValue(), (Object)"pb_").put((Object)TestItemIssueType.SYSTEM_ISSUE.getValue(), (Object)"si_").put((Object)TestItemIssueType.NO_DEFECT.getValue(), (Object)"nd_").put((Object)TestItemIssueType.TO_INVESTIGATE.getValue(), (Object)"ti_").build();
    private final ProjectRepository projectRepo;
    private final WidgetRepository widgetRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public CreateProjectSettingsHandler(ProjectRepository projectRepository, WidgetRepository widgetRepository, ApplicationEventPublisher eventPublisher) {
        this.projectRepo = projectRepository;
        this.widgetRepository = widgetRepository;
        this.eventPublisher = eventPublisher;
    }

    public EntryCreatedRS createProjectIssueSubType(String projectName, String username, CreateIssueSubTypeRQ rq) {
        Project project = (Project)this.projectRepo.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        BusinessRule.expect((Object)TestItemIssueType.TO_INVESTIGATE.getValue().equalsIgnoreCase(rq.getTypeRef()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Impossible to create sub-type for 'To Investigate' type."});
        BusinessRule.expect((Object)TestItemIssueType.NOT_ISSUE_FLAG.getValue().equalsIgnoreCase(rq.getTypeRef()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Impossible to create sub-type for 'Not Issue' type."});
        TestItemIssueType expectedType = TestItemIssueType.fromValue((String)rq.getTypeRef());
        BusinessRule.expect((Object)expectedType, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{rq.getTypeRef()});
        Map subTypes = project.getConfiguration().getSubTypes();
        BusinessRule.expect((Object)(((List)subTypes.get(expectedType)).size() < 11 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Sub Issues count is bound of size limit"});
        String newID = (String)PREFIX.get(expectedType.getValue()) + CreateProjectSettingsHandler.shortUUID();
        StatisticSubType subType = new StatisticSubType(newID, expectedType.getValue(), rq.getLongName(), rq.getShortName().toUpperCase(), rq.getColor());
        ((List)subTypes.get(expectedType)).add(subType);
        project.getConfiguration().setSubTypes(subTypes);
        try {
            this.projectRepo.save(project);
            this.widgetRepository.findByProject(projectName).stream().filter(it -> it.getContentOptions().getType().equals(WidgetDataTypes.PIE_CHART.getType()) || it.getContentOptions().getType().equals(WidgetDataTypes.LAUNCHES_TABLE.getType())).filter(it -> it.getContentOptions().getContentFields().stream().anyMatch(s -> s.contains(subType.getTypeRef().toLowerCase()))).forEach(it -> this.widgetRepository.addContentField(it.getId(), "statistics$defects$" + subType.getTypeRef().toLowerCase() + "$" + subType.getLocator()));
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during creation of custom project sub-type", (Throwable)e);
        }
        this.eventPublisher.publishEvent((Object)new DefectTypeCreatedEvent(projectName, username, subType));
        return new EntryCreatedRS(newID);
    }

    private static String shortUUID() {
        long l = ByteBuffer.wrap(UUID.randomUUID().toString().getBytes(Charsets.UTF_8)).getLong();
        return Long.toString(l, 36);
    }
}

