/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.auth.UatClient;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.user.IDeleteUserHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteUserHandler
implements IDeleteUserHandler {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UatClient uatClient;
    @Autowired
    private ILogIndexer logIndexer;

    public OperationCompletionRS deleteUser(String userId, String principal) {
        User user = (User)this.userRepository.findOne((Serializable)((Object)userId));
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{userId});
        BusinessRule.expect((Object)userId.equalsIgnoreCase(principal), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"You cannot delete own account"});
        try {
            List userProjects = this.projectRepository.findUserProjects(userId);
            userProjects.forEach(project -> ProjectUtils.excludeProjectRecipients((Iterable)Lists.newArrayList((Object[])new User[]{user}), (Project)project));
            this.projectRepository.removeUserFromProjects(userId);
            this.projectRepository.save((Iterable)userProjects);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while updating projects", (Throwable)exp);
        }
        Optional personalProjectName = this.projectRepository.findPersonalProjectName(user.getLogin());
        try {
            this.uatClient.revokeUserTokens(userId);
            this.userRepository.delete((Object)user);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while deleting user", (Throwable)exp);
        }
        personalProjectName.ifPresent(s -> this.logIndexer.deleteIndex(s));
        return new OperationCompletionRS("User with ID = '" + userId + "' successfully deleted.");
    }
}

