/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.GroupingContentLoader;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.aggregation.GroupingOperation;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GroupingContentLoader
implements IContentLoadingStrategy {
    private static final String GROUPING_LAUNCHES = "grouping_launches";
    private static final String GROUPING_BY = "grouping_by";
    @Autowired
    private LaunchRepository launchRepository;

    public Map<String, List<ChartObject>> loadContent(String projectName, Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> widgetOptions) {
        Optional groupingOption = GroupingOption.access$000((String)widgetOptions.get("grouping_launches").get(0));
        Optional groupingBy = GroupingOperation.GroupingPeriod.getByValue((String)widgetOptions.get("grouping_by").get(0));
        BusinessRule.expect((Object)groupingOption, (Predicate)Predicates.isPresent()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect grouping option. Supported are: " + Arrays.stream(GroupingOption.values()).map(GroupingOption::getValue).collect(Collectors.joining(","))});
        BusinessRule.expect((Object)groupingBy, (Predicate)Predicates.isPresent()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect grouping period. Supported are: " + Arrays.stream(GroupingOperation.GroupingPeriod.values()).map(GroupingOperation.GroupingPeriod::getValue).collect(Collectors.joining(","))});
        List fieldsForHandling = contentFields.stream().map(WidgetContentProvider.TO_UI_STYLE).collect(Collectors.toList());
        fieldsForHandling.add("start_time");
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(fieldsForHandling, metaDataFields);
        List aggregationResults = Lists.newArrayList();
        switch (1.$SwitchMap$com$epam$ta$reportportal$core$widget$content$GroupingContentLoader$GroupingOption[((GroupingOption)groupingOption.get()).ordinal()]) {
            case 1: {
                aggregationResults = this.launchRepository.findGroupedBy((Queryable)filter, contentFields, (GroupingOperation.GroupingPeriod)groupingBy.get(), quantity);
                break;
            }
            case 2: {
                aggregationResults = this.launchRepository.findLatestGroupedBy((Queryable)filter, contentFields, (GroupingOperation.GroupingPeriod)groupingBy.get(), quantity);
            }
        }
        if (aggregationResults.isEmpty()) {
            return Collections.emptyMap();
        }
        aggregationResults.forEach(arg_0 -> ((StatisticsDocumentHandler)handler).processDocument(arg_0));
        return ImmutableMap.builder().put((Object)"result", (Object)handler.getResult()).build();
    }
}

