/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WidgetContentProvider {
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;
    @Autowired
    @Qualifier(value="contentLoader")
    private Map<GadgetTypes, IContentLoadingStrategy> contentLoader;
    public static final Function<String, String> TO_UI_STYLE = db -> db.replace('.', '$');
    public static final Function<String, String> TO_DB_STYLE = model -> model.replace('$', '.');

    public Map<String, List<ChartObject>> getChartContent(String projectName, Filter filter, SelectionOptions selectionOptions, ContentOptions options) {
        Class type = filter.getTarget();
        CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(type);
        List contentFields = WidgetContentProvider.transformToDBStyle((CriteriaMap)criteriaMap, (List)options.getContentFields());
        List metaDataFields = WidgetContentProvider.transformToDBStyle((CriteriaMap)criteriaMap, (List)options.getMetadataFields());
        List orders = selectionOptions.getOrders().stream().map(order -> new Sort.Order(order.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC, criteriaMap.getCriteriaHolder(order.getSortingColumnName()).getQueryCriteria())).collect(Collectors.toList());
        Sort sort = new Sort(orders);
        IContentLoadingStrategy loadingStrategy = (IContentLoadingStrategy)this.contentLoader.get(GadgetTypes.findByName((String)options.getGadgetType()).get());
        BusinessRule.expect((Object)loadingStrategy, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{Suppliers.formattedSupplier((String)"Unknown gadget type: '{}'.", (Object[])new Object[]{options.getGadgetType()})});
        Map widgetOptions = null == options.getWidgetOptions() ? new HashMap() : options.getWidgetOptions();
        int itemsCount = options.getItemsCount();
        Map result = loadingStrategy.loadContent(projectName, filter, sort, itemsCount, contentFields, metaDataFields, widgetOptions);
        if (null != options.getContentFields()) {
            result = this.transformNamesForUI(criteriaMap, options.getContentFields(), result);
        }
        return result;
    }

    private Map<String, List<ChartObject>> transformNamesForUI(CriteriaMap<?> criteriaMap, List<String> chartFields, Map<String, List<ChartObject>> input) {
        Map<String, String> reversedCriteriaMap = chartFields.stream().collect(Collectors.toMap(field -> criteriaMap.getCriteriaHolder(field).getQueryCriteria(), field -> field));
        input.entrySet().stream().flatMap(it -> ((List)it.getValue()).stream()).forEach(chartObject -> {
            LinkedHashMap values = new LinkedHashMap();
            chartObject.getValues().keySet().forEach(key -> {
                String value = (String)chartObject.getValues().get(key);
                String queryCriteria = (String)reversedCriteriaMap.get(TO_DB_STYLE.apply(key));
                if (queryCriteria != null) {
                    values.put(queryCriteria, value);
                } else {
                    values.put(key, value);
                }
            });
            chartObject.setValues(values);
        });
        return input;
    }

    public static List<String> transformToDBStyle(CriteriaMap<?> criteriaMap, List<String> chartFields) {
        if (chartFields == null) {
            return new ArrayList<String>();
        }
        return chartFields.stream().map(it -> criteriaMap.getCriteriaHolder(it).getQueryCriteria()).collect(Collectors.toList());
    }
}

