/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.info;

import com.epam.ta.reportportal.exception.ReportPortalException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!jobs-disabled"})
public class JobSchedulerInfoContributor
implements InfoContributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerInfoContributor.class);
    @Autowired
    private Scheduler scheduler;

    public void contribute(Info.Builder builder) {
        try {
            Map<String, Map> triggersInfo = this.scheduler.getTriggerGroupNames().stream().flatMap(name -> {
                try {
                    return this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)name)).stream();
                }
                catch (SchedulerException e) {
                    LOGGER.warn(e.getMessage());
                    return Stream.empty();
                }
            }).collect(Collectors.toList()).stream().flatMap(key -> {
                try {
                    return this.scheduler.getTriggersOfJob(key).stream();
                }
                catch (SchedulerException e) {
                    LOGGER.warn(e.getMessage());
                    return Stream.empty();
                }
            }).collect(Collectors.toMap(t -> t.getKey().getName(), t -> Collections.singletonMap("triggersIn", t.getNextFireTime().getTime() - System.currentTimeMillis())));
            if (MapUtils.isNotEmpty(triggersInfo)) {
                builder.withDetail("jobs", triggersInfo);
            }
        }
        catch (SchedulerException e) {
            throw new ReportPortalException(e.getMessage());
        }
    }
}

