/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.database.entity.project.email.ProjectEmailConfig;
import com.epam.ta.reportportal.database.entity.settings.ServerEmailDetails;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MailServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServiceFactory.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final String DEFAULT_SETTINGS_PROFILE = "default";
    private final TemplateEngine templateEngine;
    private final BasicTextEncryptor encryptor;
    private final ServerSettingsRepository settingsRepository;

    @Autowired
    public MailServiceFactory(TemplateEngine templateEngine, BasicTextEncryptor encryptor, ServerSettingsRepository settingsRepository) {
        this.templateEngine = templateEngine;
        this.encryptor = encryptor;
        this.settingsRepository = settingsRepository;
    }

    public Optional<EmailService> getEmailService(ProjectEmailConfig projectConfig, ServerEmailDetails serverConfig) {
        return this.getEmailService(serverConfig).flatMap(service -> {
            Optional<ProjectEmailConfig> projectConf = Optional.ofNullable(projectConfig);
            if (projectConf.isPresent()) {
                return projectConf.filter(ProjectEmailConfig::getEmailEnabled).flatMap(pc -> {
                    Optional.ofNullable(pc.getFrom()).ifPresent(arg_0 -> ((EmailService)service).setFrom(arg_0));
                    return Optional.of(service);
                });
            }
            return Optional.of(service);
        });
    }

    public Optional<EmailService> getEmailService(ServerEmailDetails serverConfig) {
        return Optional.ofNullable(serverConfig).flatMap(serverConf -> {
            if (BooleanUtils.isFalse((Boolean)serverConf.getEnabled())) {
                return Optional.empty();
            }
            boolean authRequired = null != serverConf.getAuthEnabled() && serverConf.getAuthEnabled() != false;
            Properties javaMailProperties = new Properties();
            javaMailProperties.put("mail.smtp.connectiontimeout", (Object)5000);
            javaMailProperties.put("mail.smtp.auth", (Object)authRequired);
            javaMailProperties.put("mail.smtp.starttls.enable", (Object)(authRequired && BooleanUtils.toBoolean((Boolean)serverConf.getStarTlsEnabled()) ? 1 : 0));
            if (BooleanUtils.toBoolean((Boolean)serverConf.getSslEnabled())) {
                javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                javaMailProperties.put("mail.smtp.socketFactory.fallback", "false");
            }
            EmailService service = new EmailService(javaMailProperties);
            service.setTemplateEngine(this.templateEngine);
            service.setHost(serverConf.getHost());
            service.setPort(serverConf.getPort().intValue());
            service.setProtocol(serverConf.getProtocol());
            service.setFrom(serverConf.getFrom());
            if (authRequired) {
                service.setUsername(serverConf.getUsername());
                service.setPassword(this.encryptor.decrypt(serverConf.getPassword()));
            }
            return Optional.of(service);
        });
    }

    public Optional<EmailService> getDefaultEmailService() {
        return Optional.ofNullable(this.settingsRepository.findOne((Serializable)((Object)DEFAULT_SETTINGS_PROFILE))).flatMap(serverSettings -> this.getEmailService(serverSettings.getServerEmailDetails()));
    }

    public Optional<EmailService> getDefaultEmailService(ProjectEmailConfig projectEmailConfig) {
        return Optional.ofNullable(this.settingsRepository.findOne((Serializable)((Object)DEFAULT_SETTINGS_PROFILE))).flatMap(serverSettings -> this.getEmailService(projectEmailConfig, serverSettings.getServerEmailDetails()));
    }

    public EmailService getDefaultEmailService(ProjectEmailConfig projectEmailConfig, boolean checkConnection) {
        EmailService emailService = (EmailService)Optional.ofNullable(this.settingsRepository.findOne((Serializable)((Object)DEFAULT_SETTINGS_PROFILE))).flatMap(serverSettings -> this.getEmailService(projectEmailConfig, serverSettings.getServerEmailDetails())).orElseThrow(() -> this.emailConfigurationFail(null));
        if (checkConnection) {
            this.checkConnection(emailService);
        }
        return emailService;
    }

    public EmailService getDefaultEmailService(boolean checkConnection) {
        EmailService emailService = (EmailService)Optional.ofNullable(this.settingsRepository.findOne((Serializable)((Object)DEFAULT_SETTINGS_PROFILE))).flatMap(serverSettings -> this.getEmailService(serverSettings.getServerEmailDetails())).orElseThrow(() -> this.emailConfigurationFail(null));
        if (checkConnection) {
            this.checkConnection(emailService);
        }
        return emailService;
    }

    public void checkConnection(@Nullable EmailService service) {
        try {
            if (null == service) {
                throw this.emailConfigurationFail(null);
            }
            service.testConnection();
        }
        catch (Exception e) {
            throw this.emailConfigurationFail((Throwable)e);
        }
    }

    private ReportPortalException emailConfigurationFail(Throwable e) {
        if (null != e) {
            LOGGER.error("Cannot send email to user", e);
        }
        return new ReportPortalException(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Please configure email server in Report Portal settings."});
    }
}

