/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.converter.converters.ParametersConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.google.common.collect.Sets;
import java.sql.Date;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class TestItemBuilder
extends Builder<TestItem> {
    public TestItemBuilder addStartItemRequest(StartTestItemRQ rq) {
        List parameters;
        Set tags;
        ((TestItem)this.getObject()).setStartTime(Optional.ofNullable(rq.getStartTime()).orElse(Date.from(Instant.now())));
        ((TestItem)this.getObject()).setName(rq.getName().trim());
        ((TestItem)this.getObject()).setUniqueId(rq.getUniqueId());
        if (null != rq.getDescription()) {
            ((TestItem)this.getObject()).setItemDescription(rq.getDescription().trim());
        }
        if (null != (tags = rq.getTags())) {
            tags = Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)tags)));
        }
        if (null != (parameters = rq.getParameters())) {
            ((TestItem)this.getObject()).setParameters(parameters.stream().map(ParametersConverter.TO_MODEL).collect(Collectors.toList()));
        }
        ((TestItem)this.getObject()).setTags(tags);
        TestItemType type = TestItemType.fromValue((String)rq.getType());
        BusinessRule.expect((Object)type, (Predicate)Predicates.notNull()).verify(ErrorType.UNSUPPORTED_TEST_ITEM_TYPE, new Object[]{rq.getType()});
        ((TestItem)this.getObject()).setType(type);
        return this;
    }

    public TestItemBuilder addStatus(Status status) {
        ((TestItem)this.getObject()).setStatus(status);
        return this;
    }

    public TestItemBuilder addParent(TestItem parent) {
        ((TestItem)this.getObject()).setLaunchRef(parent.getLaunchRef());
        ((TestItem)this.getObject()).setParent(parent.getId());
        return this;
    }

    public TestItemBuilder addPath(TestItem parent) {
        if (parent.getPath() != null && !parent.getPath().isEmpty()) {
            ((TestItem)this.getObject()).getPath().addAll(parent.getPath());
        }
        ((TestItem)this.getObject()).getPath().add(parent.getId());
        return this;
    }

    public TestItemBuilder addLaunch(Launch launch) {
        ((TestItem)this.getObject()).setLaunchRef(launch.getId());
        return this;
    }

    protected TestItem initObject() {
        return new TestItem();
    }
}

