/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.core.analyzer.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.ws.converter.converters.StatisticsConverter;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.statistics.Statistics;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchConverter {
    @Autowired
    private AnalyzerStatusCache analyzerStatusCache;
    private final Function<Launch, LaunchResource> TO_RESOURCE = db -> {
        Preconditions.checkNotNull((Object)db);
        LaunchResource resource = new LaunchResource();
        resource.setLaunchId(db.getId());
        resource.setName(db.getName());
        resource.setNumber(db.getNumber());
        resource.setDescription(db.getDescription());
        resource.setStatus(db.getStatus() == null ? null : db.getStatus().toString());
        resource.setStartTime(db.getStartTime());
        resource.setEndTime(db.getEndTime());
        resource.setTags(db.getTags());
        resource.setMode(db.getMode());
        resource.setApproximateDuration(db.getApproximateDuration());
        resource.setIsProcessing(this.analyzerStatusCache.getAnalyzerStatus().getIfPresent((Object)resource.getLaunchId()) != null);
        resource.setOwner(db.getUserRef());
        resource.setHasRetries(BooleanUtils.isTrue((Boolean)db.getHasRetries()));
        resource.setStatistics((Statistics)StatisticsConverter.TO_RESOURCE.apply(db.getStatistics()));
        return resource;
    };

    public Function<Launch, LaunchResource> getLaunchConverter() {
        return this.TO_RESOURCE;
    }
}

