/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class AnalyzerStatusCache {
    private static final int CACHE_ITEM_LIVE = 100;
    private static final int MAXIMUM_SIZE = 10000;
    private Cache<String, String> analyzerStatus = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(100L, TimeUnit.MINUTES).build();

    public void analyzeStarted(String launchId, String projectName) {
        this.analyzerStatus.put((Object)launchId, (Object)projectName);
    }

    public void analyzeFinished(String launchId) {
        this.analyzerStatus.invalidate((Object)launchId);
    }

    public Cache<String, String> getAnalyzerStatus() {
        return this.analyzerStatus;
    }
}

