/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.preference.impl;

import com.epam.ta.reportportal.core.preference.IUpdatePreferenceHandler;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.database.entity.UserPreference;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.ws.converter.converters.PreferenceConverter;
import com.epam.ta.reportportal.ws.model.preference.PreferenceResource;
import com.epam.ta.reportportal.ws.model.preference.UpdatePreferenceRQ;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePreferenceHandler
implements IUpdatePreferenceHandler {
    @Autowired
    private UserPreferenceRepository userPreferenceRepository;
    @Autowired
    private UserFilterRepository filterRepository;

    public PreferenceResource updatePreference(String userName, String projectName, UpdatePreferenceRQ rq) {
        UserPreference preference = this.userPreferenceRepository.findByProjectAndUserName(projectName, userName);
        if (null == preference) {
            preference = new UserPreference();
            preference.setLaunchTabs(new UserPreference.LaunchTabs());
            preference.setUserRef(userName);
            preference.setProjectRef(projectName);
        }
        if (null != rq.getActive()) {
            preference.getLaunchTabs().setActive(rq.getActive());
        }
        List filters = this.filterRepository.find((Collection)rq.getFilters()).stream().filter(it -> it.getAcl().getOwnerUserId().equalsIgnoreCase(userName) || !it.getAcl().getEntries().isEmpty()).map(UserFilter::getId).collect(Collectors.toList());
        preference.getLaunchTabs().setFilters(filters);
        this.userPreferenceRepository.save((Object)preference);
        return (PreferenceResource)PreferenceConverter.TO_RESOURCE.apply(preference);
    }
}

