/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.IGetProjectInfoHandler;
import com.epam.ta.reportportal.core.project.impl.GetProjectStatisticHandler;
import com.epam.ta.reportportal.core.project.impl.ProjectInfoWidgetDataConverter;
import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.project.info.InfoInterval;
import com.epam.ta.reportportal.database.entity.project.info.ProjectInfoWidget;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.ProjectInfoResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.Page;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.project.LaunchesPerUser;
import com.epam.ta.reportportal.ws.model.project.ProjectInfoResource;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GetProjectStatisticHandler
implements IGetProjectInfoHandler {
    private DecimalFormat formatter = new DecimalFormat("###.##");
    private static final Double WEEKS_IN_MONTH = 4.4;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository itemRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private ProjectInfoResourceAssembler projectInfoResourceAssembler;
    @Autowired
    private ProjectInfoWidgetDataConverter dataConverter;
    private static final Predicate<ActivityEventType> ACTIVITIES_PROJECT_FILTER = it -> it == ActivityEventType.UPDATE_DEFECT || it == ActivityEventType.DELETE_DEFECT || it == ActivityEventType.LINK_ISSUE || it == ActivityEventType.LINK_ISSUE_AA || it == ActivityEventType.UNLINK_ISSUE || it == ActivityEventType.UPDATE_ITEM;

    public Iterable<ProjectInfoResource> getAllProjectsInfo(Filter filter, Pageable pageable) {
        Page preAssembled = this.projectInfoResourceAssembler.toPagedResources(this.projectRepository.findByFilter((Queryable)filter, pageable));
        for (ProjectInfoResource project : preAssembled) {
            Optional lastLaunch = this.launchRepository.findLastLaunch(project.getProjectId(), Mode.DEFAULT.name());
            lastLaunch.ifPresent(launch -> project.setLastRun(launch.getStartTime()));
            project.setLaunchesQuantity(this.launchRepository.findLaunchesQuantity(project.getProjectId(), Mode.DEFAULT.name(), null));
        }
        return preAssembled;
    }

    public ProjectInfoResource getProjectInfo(String projectId, String dataInterval) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectId));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId});
        InfoInterval interval = InfoInterval.findByName((String)dataInterval);
        BusinessRule.expect((Object)interval, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{dataInterval});
        Date date = GetProjectStatisticHandler.getStartIntervalDate((InfoInterval)interval);
        ProjectInfoResource projectInfoResource = this.projectInfoResourceAssembler.toResource(project);
        projectInfoResource.setLaunchesQuantity(this.launchRepository.findLaunchesQuantity(project.getId(), Mode.DEFAULT.name(), date));
        Map map = this.launchRepository.findGroupedLaunchesByOwner(projectId, Mode.DEFAULT.name(), date);
        List launches = this.getLaunchesInfo(map);
        projectInfoResource.setLaunchesPerUser(launches);
        projectInfoResource.setUsersQuantity(Integer.valueOf(project.getUsers().size()));
        List allLaunches = this.getLaunchesForProjectInformation(projectId, interval);
        List tickets = this.itemRepository.getUniqueTicketsCount(allLaunches);
        projectInfoResource.setUniqueTickets(Integer.valueOf(tickets.size()));
        if (null != allLaunches && !allLaunches.isEmpty()) {
            this.formatter.setRoundingMode(RoundingMode.HALF_UP);
            double value = (double)allLaunches.size() / ((double)interval.getCount().intValue() * WEEKS_IN_MONTH);
            projectInfoResource.setLaunchesPerWeek(this.formatter.format(value));
        } else {
            projectInfoResource.setLaunchesPerWeek(this.formatter.format(0L));
        }
        return projectInfoResource;
    }

    public Map<String, List<ChartObject>> getProjectInfoWidgetContent(String projectId, String dataInterval, String widgetCode) {
        Map result;
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectId));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId});
        InfoInterval interval = InfoInterval.findByName((String)dataInterval);
        BusinessRule.expect((Object)interval, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{dataInterval});
        ProjectInfoWidget widgetType = ProjectInfoWidget.findByCode((String)widgetCode);
        BusinessRule.expect((Object)widgetType, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{widgetCode});
        List allLaunches = this.getLaunchesForProjectInformation(projectId, interval);
        switch (3.$SwitchMap$com$epam$ta$reportportal$database$entity$project$info$ProjectInfoWidget[widgetType.ordinal()]) {
            case 1: {
                result = this.dataConverter.getInvestigatedProjectInfo(allLaunches, interval);
                break;
            }
            case 2: {
                result = this.dataConverter.getTestCasesStatisticsProjectInfo(allLaunches);
                break;
            }
            case 3: {
                result = this.dataConverter.getLaunchesQuantity(allLaunches, interval);
                break;
            }
            case 4: {
                result = this.dataConverter.getLaunchesIssues(allLaunches, interval);
                break;
            }
            case 5: {
                result = this.getActivities(projectId, interval);
                break;
            }
            case 6: {
                result = this.getLastLaunchStatistics(projectId);
                break;
            }
            default: {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    private Map<String, List<ChartObject>> getActivities(String projectId, InfoInterval interval) {
        String value = Arrays.stream(ActivityEventType.values()).filter(Predicates.not((Predicate)ACTIVITIES_PROJECT_FILTER)).map(ActivityEventType::getValue).collect(Collectors.joining(","));
        int limit = 150;
        Filter filter = new Filter(Activity.class, (Set)new /* Unavailable Anonymous Inner Class!! */);
        List activities = this.activityRepository.findByFilterWithSortingAndLimit(filter, new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "last_modified")}), limit);
        List chartObjects = activities.stream().map(it -> {
            ChartObject chartObject = new ChartObject();
            chartObject.setId(it.getId());
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("actionType", it.getActionType().getValue());
            values.put("last_modified", String.valueOf(it.getLastModified().getTime()));
            values.put("objectType", it.getObjectType().getValue());
            values.put("projectRef", it.getProjectRef());
            values.put("userRef", it.getUserRef());
            if (it.getLoggedObjectRef() != null) {
                values.put("loggedObjectRef", it.getLoggedObjectRef());
            }
            if (it.getName() != null) {
                values.put("name", it.getName());
            }
            it.getHistory().forEach(entry -> {
                Activity.FieldValues fieldValues = entry;
                values.put(entry.getField() + "$oldValue", entry.getOldValue());
                values.put(entry.getField() + "$newValue", entry.getNewValue());
            });
            chartObject.setValues(values);
            return chartObject;
        }).collect(Collectors.toList());
        return Collections.singletonMap("result", chartObjects);
    }

    private Map<String, List<ChartObject>> getLastLaunchStatistics(String projectId) {
        String total = "statistics$executions$total";
        String productBug = "statistics$defects$product_bug";
        String toInvestigate = "statistics$defects$to_investigate";
        String systemIssue = "statistics$defects$system_issue";
        String automationBug = "statistics$defects$automation_bug";
        String failed = "statistics$executions$failed";
        String passed = "statistics$executions$passed";
        String skipped = "statistics$executions$skipped";
        Optional launchOptional = this.launchRepository.findLastLaunch(projectId, Mode.DEFAULT.name());
        if (!launchOptional.isPresent()) {
            return Collections.emptyMap();
        }
        Launch lastLaunch = (Launch)launchOptional.get();
        ChartObject chartObject = new ChartObject();
        ExecutionCounter executionCounter = lastLaunch.getStatistics().getExecutionCounter();
        IssueCounter issueCounter = lastLaunch.getStatistics().getIssueCounter();
        chartObject.setValues((Map)new /* Unavailable Anonymous Inner Class!! */);
        chartObject.setId(lastLaunch.getId());
        chartObject.setName(lastLaunch.getName());
        chartObject.setStartTime(String.valueOf(lastLaunch.getStartTime().getTime()));
        chartObject.setNumber(lastLaunch.getNumber().toString());
        return Collections.singletonMap("result", Collections.singletonList(chartObject));
    }

    private List<LaunchesPerUser> getLaunchesInfo(Map<String, Integer> input) {
        ArrayList result = Lists.newArrayList();
        Iterator<Map.Entry<String, Integer>> iterator = input.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> pair = iterator.next();
            User user = (User)this.userRepository.findOne((Serializable)((Object)pair.getKey()));
            if (null != user) {
                LaunchesPerUser single = new LaunchesPerUser(user.getFullName(), input.get(pair.getKey()));
                result.add(single);
            }
            iterator.remove();
        }
        return result;
    }

    private List<Launch> getLaunchesForProjectInformation(String projectId, InfoInterval interval) {
        Date date = GetProjectStatisticHandler.getStartIntervalDate((InfoInterval)interval);
        return this.launchRepository.findLaunchesByProjectId(projectId, date, Mode.DEFAULT.name());
    }

    private static Date getStartIntervalDate(InfoInterval input) {
        DateTime now = new DateTime().toDateTime(DateTimeZone.UTC);
        DateTime range = now.minusMonths(input.getCount().intValue());
        return range.toDate();
    }

    static /* synthetic */ Date access$000(InfoInterval x0) {
        return GetProjectStatisticHandler.getStartIntervalDate((InfoInterval)x0);
    }
}

