/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.history.LastLaunchFilterStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MostTimeConsumingFilterStrategy
extends LastLaunchFilterStrategy {
    private TestItemRepository testItemRepository;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    public Map<String, ?> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        Optional lastLaunch = this.getLastLaunch(contentOptions, projectName);
        if (!lastLaunch.isPresent()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ChartObject>> res = new HashMap<String, List<ChartObject>>(2);
        Launch last = (Launch)lastLaunch.get();
        Filter filter = this.createFilter(last.getId(), contentOptions);
        res.put("result", this.testItemRepository.findMostTimeConsumingTestItems((Queryable)filter, contentOptions.getItemsCount()));
        ChartObject lastLaunchChartObject = new ChartObject();
        lastLaunchChartObject.setName(last.getName());
        lastLaunchChartObject.setNumber(last.getNumber().toString());
        lastLaunchChartObject.setId(last.getId());
        res.put("lastLaunch", Collections.singletonList(lastLaunchChartObject));
        return res;
    }

    private Filter createFilter(String lastId, ContentOptions contentOptions) {
        HashSet<FilterCondition> filterConditions = new HashSet<FilterCondition>();
        filterConditions.add(new FilterCondition(Condition.IN, false, this.getCriteria(contentOptions).stream().map(String::toUpperCase).collect(Collectors.joining(",")), "status"));
        filterConditions.add(new FilterCondition(Condition.EQUALS, false, lastId, "launch"));
        filterConditions.add(new FilterCondition(Condition.EQUALS, false, "false", "has_childs"));
        if (!contentOptions.getWidgetOptions().containsKey("include_methods")) {
            filterConditions.add(new FilterCondition(Condition.EQUALS, false, "STEP", "type"));
        }
        return new Filter(TestItem.class, filterConditions);
    }

    private List<String> getCriteria(ContentOptions contentOptions) {
        List<String> criteria = Optional.ofNullable(contentOptions.getContentFields()).orElse(Collections.emptyList()).stream().map(it -> it.split("\\$")).map(split -> split[((String[])split).length - 1].toUpperCase()).collect(Collectors.toList());
        BusinessRule.expect((Object)criteria.isEmpty(), Predicate.isEqual(false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect list of content fields."});
        return criteria;
    }
}

