/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.history;

import com.epam.ta.reportportal.core.widget.content.history.FlakyTestCasesStrategy;
import com.epam.ta.reportportal.core.widget.content.history.HistoryTestCasesStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.history.status.FlakyHistory;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FlakyTestCasesStrategy
extends HistoryTestCasesStrategy {
    private static final String FLAKY = "flaky";
    @Autowired
    private TestItemRepository itemRepository;

    public Map<String, List<?>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        List launchHistory = this.getLaunchHistory(contentOptions, projectName);
        if (CollectionUtils.isEmpty((Collection)launchHistory)) {
            return Collections.emptyMap();
        }
        List itemStatusHistory = this.itemRepository.getFlakyItemStatusHistory(this.buildHistoryFilter(contentOptions, launchHistory));
        if (CollectionUtils.isEmpty((Collection)itemStatusHistory)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<?>> result = new HashMap(2);
        result = this.processHistory(result, itemStatusHistory);
        this.addLastLaunch(result, launchHistory);
        return result;
    }

    private Map<String, List<?>> processHistory(Map<String, List<?>> result, List<FlakyHistory> itemStatusHistory) {
        List flakyHistoryObjects = itemStatusHistory.stream().map(arg_0 -> this.processItem(arg_0)).collect(Collectors.toList());
        flakyHistoryObjects.sort(Comparator.comparing(FlakyHistoryObject::getSwitchCounter, Comparator.reverseOrder()).thenComparing(HistoryTestCasesStrategy.HistoryObject::getTotal));
        if (flakyHistoryObjects.size() > 20) {
            flakyHistoryObjects = flakyHistoryObjects.subList(0, 20);
        }
        result.put(FLAKY, flakyHistoryObjects);
        return result;
    }

    private FlakyHistoryObject processItem(FlakyHistory historyItem) {
        List statusHistory = historyItem.getStatusHistory();
        Date lastSwitched = ((FlakyHistory.HistoryEntry)statusHistory.get(0)).getStartTime();
        int potentialSwitches = historyItem.getTotal() - 1;
        int switchCounter = 0;
        ArrayList<String> statuses = new ArrayList<String>();
        String prevStatus = ((FlakyHistory.HistoryEntry)statusHistory.get(0)).getStatus();
        for (FlakyHistory.HistoryEntry entry : statusHistory) {
            if (!entry.getStatus().equals(prevStatus)) {
                lastSwitched = entry.getStartTime();
                ++switchCounter;
            }
            statuses.add(entry.getStatus());
            prevStatus = entry.getStatus();
        }
        FlakyHistoryObject flakyHistoryObject = new FlakyHistoryObject(null);
        flakyHistoryObject.setUniqueId(historyItem.getUniqueId());
        flakyHistoryObject.setName(historyItem.getName());
        flakyHistoryObject.setTotal(potentialSwitches);
        flakyHistoryObject.setSwitchCounter(switchCounter);
        flakyHistoryObject.setPercentage(this.countPercentage(switchCounter, potentialSwitches));
        flakyHistoryObject.setLastTime(lastSwitched);
        flakyHistoryObject.setStatuses(statuses);
        return flakyHistoryObject;
    }
}

