/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.history;

import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.core.widget.content.history.LastLaunchFilterStrategy;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class HistoryTestCasesStrategy
extends LastLaunchFilterStrategy {
    @Autowired
    protected LaunchRepository launchRepository;
    @Autowired
    private ITestItemsHistoryService historyServiceStrategy;

    List<Launch> getLaunchHistory(ContentOptions contentOptions, String projectName) {
        Optional lastLaunch = this.getLastLaunch(contentOptions, projectName);
        if (!lastLaunch.isPresent()) {
            return Collections.emptyList();
        }
        List launchHistory = this.historyServiceStrategy.loadLaunches(contentOptions.getItemsCount(), ((Launch)lastLaunch.get()).getId(), projectName, false);
        if (launchHistory.isEmpty()) {
            return Collections.emptyList();
        }
        return launchHistory;
    }

    void addLastLaunch(Map<String, List<?>> result, List<Launch> launches) {
        if (!CollectionUtils.isEmpty(launches)) {
            Launch last = launches.get(0);
            ChartObject lastLaunch = new ChartObject();
            lastLaunch.setName(last.getName());
            lastLaunch.setNumber(last.getNumber().toString());
            lastLaunch.setId(last.getId());
            result.put("lastLaunch", Collections.singletonList(lastLaunch));
        }
    }

    Queryable buildHistoryFilter(ContentOptions contentOptions, List<Launch> launches) {
        HashSet<FilterCondition> filterConditions = new HashSet<FilterCondition>();
        filterConditions.add(new FilterCondition(Condition.IN, false, launches.stream().map(Launch::getId).collect(Collectors.joining(",")), "launch"));
        filterConditions.add(new FilterCondition(Condition.EQUALS, false, "false", "has_childs"));
        if (!contentOptions.getWidgetOptions().containsKey("include_methods")) {
            filterConditions.add(new FilterCondition(Condition.EQUALS, false, "STEP", "type"));
        }
        return new Filter(TestItem.class, filterConditions);
    }

    String countPercentage(int amount, int total) {
        return String.format("%.2f", (double)amount / (double)total * 100.0) + "%";
    }
}

