/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import com.epam.ta.reportportal.job.PageUtil;
import com.mongodb.gridfs.GridFSDBFile;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CleanScreenshotsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanScreenshotsJob.class);
    private static final int FILES_LIMIT = 150;
    @Autowired
    private DataStorage gridFS;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LogRepository logRepository;

    public void execute(JobExecutionContext context) {
        LOGGER.info("Cleaning outdated screenshots has been started");
        PageUtil.iterateOverPages(arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndConfiguration(arg_0), projects -> projects.forEach(project -> {
            AtomicLong count = new AtomicLong(0L);
            try {
                LOGGER.info("Cleaning outdated screenshots for project {} has been started", (Object)project.getId());
                Duration period = Duration.ofDays(KeepScreenshotsDelay.findByName((String)project.getConfiguration().getKeepScreenshots()).getDays());
                if (!period.isZero()) {
                    List dbObjects = this.gridFS.findFirstModifiedLater(period, project.getId(), 150);
                    while (dbObjects != null && dbObjects.size() > 0) {
                        List fileIds = dbObjects.stream().map(it -> (GridFSDBFile)it).filter(it -> !it.getFilename().startsWith("photo_")).map(it -> it.getId().toString()).collect(Collectors.toList());
                        this.gridFS.deleteData(fileIds);
                        this.logRepository.removeBinaryContent(fileIds);
                        count.addAndGet(fileIds.size());
                        dbObjects = this.gridFS.findFirstModifiedLater(period, project.getId(), 150);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info("Cleaning outdated screenshots for project {} has been failed", (Object)project.getId(), (Object)e);
            }
            LOGGER.info("Cleaning outdated screenshots for project {} has been finished. {} deleted", (Object)project.getId(), (Object)count.get());
        }));
    }
}

