/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.Constants;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.RestorePasswordBidRepository;
import com.epam.ta.reportportal.database.dao.UserCreationBidRepository;
import com.epam.ta.reportportal.database.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.demo_data.DemoDataRq;
import com.epam.ta.reportportal.demo_data.DemoDataService;
import com.epam.ta.reportportal.events.handler.AddDemoProjectEventHandler;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"demo"})
public class FlushingDataJob
implements Job {
    @Value(value="${rp.demo.data}")
    private Integer launchesCount;
    @Autowired
    private UserCreationBidRepository creationBidRepository;
    @Autowired
    private RestorePasswordBidRepository passwordBidRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserPreferenceRepository preferenceRepository;
    @Autowired
    private ILogIndexer logIndexer;
    @Autowired
    private AddDemoProjectEventHandler addDemoProjectEventHandler;
    @Autowired
    private DataStorage dataStorage;
    @Autowired
    private DemoDataService demoDataService;
    @Autowired
    private MongoOperations mongoOperations;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushingDataJob.class);

    public void execute(JobExecutionContext context) {
        LOGGER.info("Start flushing all existing data!");
        this.mongoOperations.dropCollection("launchMetaInfo");
        this.mongoOperations.dropCollection("oauth_access_token");
        this.mongoOperations.dropCollection("oauth_refresh_token");
        this.mongoOperations.dropCollection("sessions");
        this.passwordBidRepository.deleteAll();
        this.creationBidRepository.deleteAll();
        List<String> projectNames = this.projectRepository.findAllProjectNames().stream().filter(it -> !it.startsWith(Constants.DEFAULT_ADMIN.toString() + "_personal")).collect(Collectors.toList());
        this.projectRepository.delete(projectNames);
        projectNames.forEach(name -> this.logIndexer.deleteIndex(name));
        List users = this.userRepository.findAll().stream().map(User::getLogin).filter(it -> !it.equalsIgnoreCase(Constants.DEFAULT_ADMIN.toString())).collect(Collectors.toList());
        this.userRepository.delete(users);
        this.preferenceRepository.deleteAll();
        this.dataStorage.deleteAll();
        User superadmin = (User)this.userRepository.findOne((Serializable)((Object)Constants.DEFAULT_ADMIN.toString()));
        String photoId = this.userRepository.uploadUserPhoto(superadmin.getLogin(), new BinaryData("image/jpeg", null, FlushingDataJob.class.getClassLoader().getResourceAsStream("superAdminPhoto.jpg")));
        superadmin.setPhotoId(photoId);
        this.userRepository.save((Object)superadmin);
        this.addDemoProjectEventHandler.addDefaultUser();
        DemoDataRq demoDataRq = new DemoDataRq();
        demoDataRq.setPostfix("Demo");
        demoDataRq.setCreateDashboard(true);
        demoDataRq.setLaunchesQuantity(this.launchesCount.intValue());
        this.demoDataService.generate(demoDataRq, Constants.DEFAULT_USER.toString() + "_personal", Constants.DEFAULT_USER.toString());
        LOGGER.info("Finish flushing all existing data!");
    }
}

