/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.settings.ServerEmailDetails;
import com.epam.ta.reportportal.database.entity.settings.ServerSettings;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailResource;
import com.epam.ta.reportportal.ws.model.settings.ServerSettingsResource;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public final class ServerSettingsConverter {
    public static final Function<ServerSettings, ServerSettingsResource> TO_RESOURCE = settings -> {
        Preconditions.checkNotNull((Object)settings);
        ServerSettingsResource resource = new ServerSettingsResource();
        resource.setProfile(settings.getId());
        resource.setActive(settings.getActive());
        ServerEmailDetails serverEmailDetails = settings.getServerEmailDetails();
        if (null != serverEmailDetails) {
            ServerEmailResource output = new ServerEmailResource();
            output.setHost(serverEmailDetails.getHost());
            output.setPort(serverEmailDetails.getPort());
            output.setProtocol(serverEmailDetails.getProtocol());
            output.setAuthEnabled(serverEmailDetails.getAuthEnabled());
            output.setSslEnabled(Boolean.valueOf(BooleanUtils.isTrue((Boolean)serverEmailDetails.getSslEnabled())));
            output.setStarTlsEnabled(Boolean.valueOf(BooleanUtils.isTrue((Boolean)serverEmailDetails.getStarTlsEnabled())));
            output.setFrom(serverEmailDetails.getFrom());
            if (serverEmailDetails.getAuthEnabled().booleanValue()) {
                output.setUsername(serverEmailDetails.getUsername());
            }
            resource.setServerEmailResource(output);
        }
        return resource;
    };

    private ServerSettingsConverter() {
    }
}

