/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.admin;

import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.ServerSettings;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.ServerSettingsConverter;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.settings.AnalyticsResource;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerAdminHandlerImpl
implements ServerAdminHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAdminHandlerImpl.class);
    private final BasicTextEncryptor simpleEncryptor;
    private final ServerSettingsRepository serverSettingsRepository;
    private final MailServiceFactory emailServiceFactory;

    @Autowired
    public ServerAdminHandlerImpl(BasicTextEncryptor simpleEncryptor, ServerSettingsRepository serverSettingsRepository, MailServiceFactory emailServiceFactory) {
        this.simpleEncryptor = simpleEncryptor;
        this.serverSettingsRepository = serverSettingsRepository;
        this.emailServiceFactory = emailServiceFactory;
    }

    @Override
    public Map<String, String> getServerSettings() {
        return ServerSettingsConverter.TO_RESOURCE.apply(this.serverSettingsRepository.findAll());
    }

    @Override
    public OperationCompletionRS saveAnalyticsSettings(AnalyticsResource analyticsResource) {
        String analyticsType = analyticsResource.getType();
        Map<String, ServerSettings> serverAnalyticsDetails = this.findServerSettings().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("server.analytics.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String formattedAnalyticsType = analyticsType.startsWith("server.analytics.") ? analyticsType : "server.analytics." + analyticsType;
        ServerSettings analyticsDetails = Optional.ofNullable(serverAnalyticsDetails.get(formattedAnalyticsType)).orElseGet(ServerSettings::new);
        analyticsDetails.setKey(formattedAnalyticsType);
        analyticsDetails.setValue(String.valueOf(Optional.ofNullable(analyticsResource.getEnabled()).orElse(false)));
        this.serverSettingsRepository.save((Object)analyticsDetails);
        return new OperationCompletionRS("Server Settings were successfully updated.");
    }

    private Map<String, ServerSettings> findServerSettings() {
        return this.serverSettingsRepository.findAll().stream().collect(Collectors.toMap(ServerSettings::getKey, s -> s, (prev, curr) -> prev));
    }
}

