/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.auth.acl.ReportPortalAclAuthorizationStrategyImpl;
import com.epam.ta.reportportal.auth.acl.ReportPortalAclService;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.acls.AclPermissionEvaluator;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.ConsoleAuditLogger;
import org.springframework.security.acls.domain.DefaultPermissionGrantingStrategy;
import org.springframework.security.acls.domain.SpringCacheBasedAclCache;
import org.springframework.security.acls.jdbc.BasicLookupStrategy;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Configuration
@EnableAutoConfiguration
public class ACLContext {
    @Autowired
    DataSource dataSource;

    @Bean
    public SpringCacheBasedAclCache aclCache() {
        return new SpringCacheBasedAclCache((Cache)this.coffeinCache(), this.permissionGrantingStrategy(), this.aclAuthorizationStrategy());
    }

    @Bean
    public CaffeineCache coffeinCache() {
        return new CaffeineCache("aclCache", Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(5000L).initialCapacity(2000).build());
    }

    @Bean
    public PermissionGrantingStrategy permissionGrantingStrategy() {
        return new DefaultPermissionGrantingStrategy((AuditLogger)new ConsoleAuditLogger());
    }

    @Bean
    public AclAuthorizationStrategy aclAuthorizationStrategy() {
        return new ReportPortalAclAuthorizationStrategyImpl(new GrantedAuthority[]{new SimpleGrantedAuthority(UserRole.ADMINISTRATOR.getAuthority())});
    }

    @Bean
    public LookupStrategy lookupStrategy() {
        BasicLookupStrategy lookupStrategy = new BasicLookupStrategy(this.dataSource, (AclCache)this.aclCache(), this.aclAuthorizationStrategy(), (AuditLogger)new ConsoleAuditLogger());
        lookupStrategy.setAclClassIdSupported(true);
        return lookupStrategy;
    }

    @Bean
    public ReportPortalAclService aclService() {
        return new ReportPortalAclService(this.dataSource, this.lookupStrategy(), (AclCache)this.aclCache());
    }

    @Bean
    public AclPermissionEvaluator aclPermissionEvaluator() {
        return new AclPermissionEvaluator((AclService)this.aclService());
    }
}

