/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.attachment.DeleteTestItemAttachmentsEvent;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteTestItemHandlerImpl
implements DeleteTestItemHandler {
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final LogIndexer logIndexer;
    private final LaunchRepository launchRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public DeleteTestItemHandlerImpl(TestItemRepository testItemRepository, LogRepository logRepository, LogIndexer logIndexer, LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher) {
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.logIndexer = logIndexer;
        this.launchRepository = launchRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public OperationCompletionRS deleteTestItem(Long itemId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser reportPortalUser) {
        TestItem item = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)item.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{item.getLaunchId()}));
        this.validate(item, launch, reportPortalUser, projectDetails);
        Optional<TestItem> parent = Optional.ofNullable(item.getParent());
        this.testItemRepository.deleteById((Object)item.getItemId());
        this.logIndexer.cleanIndex(projectDetails.getProjectId(), this.logRepository.findIdsByTestItemId(item.getItemId()));
        launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        parent.ifPresent(p -> p.setHasChildren(this.testItemRepository.hasChildren(p.getItemId(), p.getPath())));
        this.eventPublisher.publishEvent((Object)new DeleteTestItemAttachmentsEvent(item.getItemId()));
        return new OperationCompletionRS("Test Item with ID = '" + itemId + "' has been successfully deleted.");
    }

    @Override
    public List<OperationCompletionRS> deleteTestItem(Long[] ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser reportPortalUser) {
        return Stream.of(ids).map(it -> this.deleteTestItem((Long)it, projectDetails, reportPortalUser)).collect(Collectors.toList());
    }

    private void validate(TestItem testItem, Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Deleting testItem '{}' is not under specified project '{}'", (Object[])new Object[]{testItem.getItemId(), projectDetails.getProjectId()})});
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not a launch owner."});
            }
        }
        BusinessRule.expect((Object)testItem.getRetryOf(), Objects::isNull).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] because it is a retry", (Object[])new Object[]{testItem.getItemId()}).get()});
        BusinessRule.expect((Object)testItem.getItemResults().getStatus(), (Predicate)Predicates.not(it -> it.equals((Object)StatusEnum.IN_PROGRESS))).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] in progress state", (Object[])new Object[]{testItem.getItemId()})});
        BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not(it -> it.equals((Object)StatusEnum.IN_PROGRESS))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] under launch ['{}'] with 'In progress' state", (Object[])new Object[]{testItem.getItemId(), launch.getId()})});
    }
}

