/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.TicketRepository;
import com.epam.ta.reportportal.dao.constant.WidgetContentRepositoryConstants;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.filter.ObjectType;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.item.PathName;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.TestItemResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
class GetTestItemHandlerImpl
implements GetTestItemHandler {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ItemAttributeRepository itemAttributeRepository;
    private final TestItemResourceAssembler itemResourceAssembler;
    private final TicketRepository ticketRepository;
    private final GetShareableEntityHandler<UserFilter> getShareableEntityHandler;

    @Autowired
    public GetTestItemHandlerImpl(LaunchRepository launchRepository, TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, TestItemResourceAssembler itemResourceAssembler, TicketRepository ticketRepository, GetShareableEntityHandler<UserFilter> getShareableEntityHandler) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.itemAttributeRepository = itemAttributeRepository;
        this.itemResourceAssembler = itemResourceAssembler;
        this.ticketRepository = ticketRepository;
        this.getShareableEntityHandler = getShareableEntityHandler;
    }

    @Override
    public TestItemResource getTestItem(String testItemId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        TestItem testItem;
        try {
            testItem = (TestItem)this.testItemRepository.findById((Object)Long.parseLong(testItemId)).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId}));
        }
        catch (NumberFormatException e) {
            testItem = (TestItem)this.testItemRepository.findByUuid(testItemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId}));
        }
        this.validate(testItem.getLaunchId(), projectDetails, user);
        Map<Long, PathName> pathNamesMapping = this.getPathNamesMapping(Collections.singletonList(testItem), projectDetails.getProjectId());
        return this.itemResourceAssembler.toResource(testItem, pathNamesMapping.get(testItem.getItemId()));
    }

    @Override
    public Iterable<TestItemResource> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, @Nullable Long launchId, @Nullable Long filterId, boolean isLatest, int launchesLimit) {
        Optional<Long> launchIdOptional = Optional.ofNullable(launchId);
        Optional<Long> filterIdOptional = Optional.ofNullable(filterId);
        Page testItemPage = filterIdOptional.map(launchFilterId -> {
            this.validateProjectRole(projectDetails, user);
            return this.getItemsWithLaunchesFiltering(filter, pageable, projectDetails, (Long)launchFilterId, isLatest, launchesLimit);
        }).orElseGet(() -> launchIdOptional.map(id -> {
            this.validate((Long)id, projectDetails, user);
            return this.testItemRepository.findByFilter(filter, pageable);
        }).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Neither launch nor filter id specified."})));
        Map<Long, PathName> pathNamesMapping = this.getPathNamesMapping(testItemPage.getContent(), projectDetails.getProjectId());
        return (Iterable)PagedResourcesAssembler.pageConverter(item -> this.itemResourceAssembler.toResource((TestItem)item, (PathName)pathNamesMapping.get(item.getItemId()))).apply((Page<TestItem>)testItemPage);
    }

    @Override
    public List<String> getTicketIds(Long launchId, String term) {
        BusinessRule.expect((Object)(term.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{term})});
        return this.ticketRepository.findByTerm(launchId, term);
    }

    @Override
    public List<String> getAttributeKeys(Long launchFilterId, boolean isLatest, int launchesLimit, ReportPortalUser.ProjectDetails projectDetails, String keyPart) {
        UserFilter userFilter = this.getShareableEntityHandler.getPermitted(launchFilterId, projectDetails);
        Filter launchFilter = this.createLaunchFilter(projectDetails, userFilter);
        Pageable launchPageable = this.createLaunchPageable(userFilter, launchesLimit);
        return this.itemAttributeRepository.findAllKeysByLaunchFilter((Queryable)launchFilter, launchPageable, isLatest, keyPart, false);
    }

    @Override
    public List<String> getAttributeKeys(Long launchId, String value) {
        return this.itemAttributeRepository.findTestItemAttributeKeys(launchId, value, false);
    }

    @Override
    public List<String> getAttributeValues(Long launchId, String key, String value) {
        return this.itemAttributeRepository.findTestItemAttributeValues(launchId, key, value, false);
    }

    @Override
    public List<TestItemResource> getTestItems(Long[] ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List items = user.getUserRole() != UserRole.ADMINISTRATOR ? this.testItemRepository.findByFilter((Queryable)this.getItemsFilter(ids, projectDetails)) : this.testItemRepository.findAllById(Arrays.asList(ids));
        return items.stream().map(this.itemResourceAssembler::toResource).collect(Collectors.toList());
    }

    private void validate(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Specified launch with id '{}' not referenced to specified project with id '{}'", (Object[])new Object[]{launch.getId(), projectDetails.getProjectId()})});
            BusinessRule.expect((Object)(projectDetails.getProjectRole() == ProjectRole.OPERATOR && launch.getMode() == LaunchModeEnum.DEBUG ? 1 : 0), Predicate.isEqual(false)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }

    private void validateProjectRole(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)(projectDetails.getProjectRole() == ProjectRole.OPERATOR ? 1 : 0), Predicate.isEqual(false)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }

    private Filter getItemsFilter(Long[] ids, ReportPortalUser.ProjectDetails projectDetails) {
        Filter filter = Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("id").withCondition(Condition.IN).withValue(Arrays.stream(ids).map(Object::toString).collect(Collectors.joining(","))).build()).build();
        return projectDetails.getProjectRole() != ProjectRole.OPERATOR ? filter : filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("mode", LaunchModeEnum.DEFAULT.name()).build());
    }

    private Page<TestItem> getItemsWithLaunchesFiltering(Queryable testItemFilter, Pageable testItemPageable, ReportPortalUser.ProjectDetails projectDetails, Long launchFilterId, boolean isLatest, int launchesLimit) {
        UserFilter userFilter = this.getShareableEntityHandler.getPermitted(launchFilterId, projectDetails);
        Filter launchFilter = this.createLaunchFilter(projectDetails, userFilter);
        Pageable launchPageable = this.createLaunchPageable(userFilter, launchesLimit);
        return this.testItemRepository.findByFilter(isLatest, (Queryable)launchFilter, testItemFilter, launchPageable, testItemPageable);
    }

    private Filter createLaunchFilter(ReportPortalUser.ProjectDetails projectDetails, UserFilter launchFilter) {
        this.validateLaunchFilterTarget(launchFilter);
        Filter filter = Filter.builder().withTarget(launchFilter.getTargetClass().getClassObject()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withCondition(Condition.NOT_EQUALS).withSearchCriteria("status").withValue(StatusEnum.IN_PROGRESS.name()).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("mode", Mode.DEFAULT.toString()).build()).build();
        filter.getFilterConditions().addAll(launchFilter.getFilterCondition());
        return filter;
    }

    private void validateLaunchFilterTarget(UserFilter launchFilter) {
        BusinessRule.expect((Object)launchFilter, f -> ObjectType.Launch.equals((Object)f.getTargetClass())).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Incorrect filter target - '{}'. Allowed: '{}'", (Object[])new Object[]{launchFilter.getTargetClass(), ObjectType.Launch})});
    }

    private Pageable createLaunchPageable(UserFilter launchFilter, int launchesLimit) {
        BusinessRule.expect((Object)launchesLimit, limit -> limit > 0 && limit <= WidgetContentRepositoryConstants.LAUNCHES_COUNT).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launches limit should be greater than 0 and less or equal to 600"});
        Sort sort = Optional.ofNullable(launchFilter.getFilterSorts()).map(sorts -> Sort.by(sorts.stream().map(s -> Sort.Order.by((String)s.getField()).with(s.getDirection())).collect(Collectors.toList()))).orElseGet(Sort::unsorted);
        return PageRequest.of((int)0, (int)launchesLimit, (Sort)sort);
    }

    private Map<Long, PathName> getPathNamesMapping(List<TestItem> testItems, Long projectId) {
        return this.testItemRepository.selectPathNames((Collection)testItems.stream().map(TestItem::getItemId).collect(Collectors.toList()), projectId);
    }
}

