/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TestItemsHistoryHandlerImpl
implements TestItemsHistoryHandler {
    private static final int ITEMS_HISTORY_LIMIT = 2000;
    private TestItemRepository testItemRepository;
    private LaunchRepository launchRepository;

    @Autowired
    public TestItemsHistoryHandlerImpl(TestItemRepository testItemRepository, LaunchRepository launchRepository) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
    }

    @Override
    public List<TestItemHistoryElement> getItemsHistory(ReportPortalUser.ProjectDetails projectDetails, Long[] startPointsIds, int historyDepth, boolean showBrokenLaunches) {
        this.validateHistoryDepth(historyDepth);
        ArrayList itemIds = Lists.newArrayList((Object[])startPointsIds);
        List itemsForHistory = this.testItemRepository.findAllById((Iterable)itemIds);
        this.validateItems(itemsForHistory, itemIds, projectDetails.getProjectId());
        TestItem itemForHistory = (TestItem)itemsForHistory.get(0);
        Long launchId = itemForHistory.getLaunchId();
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        List launchesHistory = this.launchRepository.findLaunchesHistory(historyDepth, launchId, launch.getName(), projectDetails.getProjectId());
        this.validateLaunches(launchesHistory);
        int itemsLimitPerLaunch = 2000 / historyDepth;
        List itemsHistory = this.testItemRepository.loadItemsHistory(itemsForHistory.stream().map(TestItem::getUniqueId).collect(Collectors.toList()), launchesHistory.stream().map(Launch::getId).collect(Collectors.toList()), itemsLimitPerLaunch);
        Map<Long, List<TestItem>> groupedByLaunch = itemsHistory.stream().collect(Collectors.groupingBy(TestItem::getLaunchId));
        this.addRequestedItemsToFirstLaunch(groupedByLaunch, launchId, itemsForHistory);
        return launchesHistory.stream().map(l -> this.buildHistoryElement((Launch)l, (List)groupedByLaunch.get(l.getId()))).collect(Collectors.toList());
    }

    public void validateItems(List<TestItem> itemsForHistory, List<Long> ids, Long projectId) {
        BusinessRule.expect(itemsForHistory, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        Set projectIds = this.launchRepository.findAllById((Iterable)itemsForHistory.stream().map(TestItem::getLaunchId).collect(Collectors.toSet())).stream().map(Launch::getProjectId).collect(Collectors.toSet());
        BusinessRule.expect((Object)(projectIds.size() == 1 && projectIds.contains(projectId) ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        ids.removeAll(itemsForHistory.stream().map(TestItem::getItemId).collect(Collectors.toList()));
        BusinessRule.expect((Object)ids.isEmpty(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        this.checkItemsIsSiblings(itemsForHistory);
    }

    private void validateLaunches(List<Launch> launches) {
        BusinessRule.expect((Object)CollectionUtils.isEmpty(launches), Predicate.isEqual(false)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Launches are not found"});
    }

    private void checkItemsIsSiblings(List<TestItem> itemsForHistory) {
        if (null == itemsForHistory.get(0).getParent()) {
            Long launchId = itemsForHistory.get(0).getLaunchId();
            itemsForHistory.forEach(it -> BusinessRule.expect((Object)it.getLaunchId(), launch -> Objects.equals(launch, launchId)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"All test items should be siblings."}));
        } else {
            itemsForHistory.forEach(it -> BusinessRule.expect((Object)it.getParent().getItemId(), parent -> Objects.equals(parent, ((TestItem)itemsForHistory.get(0)).getParent().getItemId())).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"All test items should be siblings."}));
        }
    }

    private void validateHistoryDepth(int historyDepth) {
        Predicate<Integer> greaterThan = t -> t > 0;
        Predicate<Integer> lessThan = t -> t < 31;
        String historyDepthMessage = "Items history depth should be greater than '0' and lower than '31'";
        BusinessRule.expect((Object)historyDepth, greaterThan.and(lessThan)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{historyDepthMessage});
    }

    private TestItemHistoryElement buildHistoryElement(Launch launch, List<TestItem> testItems) {
        List<Object> resources = new ArrayList();
        if (testItems != null) {
            resources = testItems.stream().map(TestItemConverter.TO_RESOURCE).collect(Collectors.toList());
        }
        TestItemHistoryElement testItemHistoryElement = new TestItemHistoryElement();
        testItemHistoryElement.setLaunchId(launch.getId());
        testItemHistoryElement.setLaunchNumber(launch.getNumber().toString());
        testItemHistoryElement.setStartTime(launch.getStartTime().toString());
        testItemHistoryElement.setResources(resources);
        testItemHistoryElement.setLaunchStatus(launch.getStatus().name());
        return testItemHistoryElement;
    }

    private void addRequestedItemsToFirstLaunch(Map<Long, List<TestItem>> groupedByLaunch, Long launchId, List<TestItem> itemsForHistory) {
        Optional<List<TestItem>> firstLaunchLimitedItems = Optional.ofNullable(groupedByLaunch.get(launchId));
        itemsForHistory.forEach(item -> {
            if (firstLaunchLimitedItems.isPresent() && !((List)firstLaunchLimitedItems.get()).contains(item)) {
                ((List)firstLaunchLimitedItems.get()).add(item);
            }
        });
    }
}

