/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import org.hibernate.Hibernate;

public abstract class StatusChangingStrategy {
    public static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    protected final TestItemRepository testItemRepository;
    final ItemAttributeRepository itemAttributeRepository;
    protected final IssueTypeHandler issueTypeHandler;
    final IssueEntityRepository issueEntityRepository;
    protected final LaunchRepository launchRepository;
    protected final MessageBus messageBus;

    StatusChangingStrategy(TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueTypeHandler issueTypeHandler, IssueEntityRepository issueEntityRepository, LaunchRepository launchRepository, MessageBus messageBus) {
        this.testItemRepository = testItemRepository;
        this.itemAttributeRepository = itemAttributeRepository;
        this.issueTypeHandler = issueTypeHandler;
        this.issueEntityRepository = issueEntityRepository;
        this.launchRepository = launchRepository;
        this.messageBus = messageBus;
    }

    public abstract void changeStatus(TestItem var1, StatusEnum var2, ReportPortalUser var3, Long var4);

    void addToInvestigateIssue(TestItem testItem, Long projectId) {
        IssueEntity issueEntity = new IssueEntity();
        IssueType toInvestigate = this.issueTypeHandler.defineIssueType(projectId, TestItemIssueGroup.TO_INVESTIGATE.getLocator());
        issueEntity.setIssueType(toInvestigate);
        issueEntity.setTestItemResults(testItem.getItemResults());
        this.issueEntityRepository.save((Object)issueEntity);
        testItem.getItemResults().setIssue(issueEntity);
    }

    void changeStatusRecursively(TestItem testItem, ReportPortalUser user, Long projectId) {
        TestItem parent = testItem.getParent();
        Hibernate.initialize((Object)parent);
        if (parent != null) {
            StatusEnum newStatus;
            TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(parent, projectId);
            StatusEnum statusEnum = newStatus = this.testItemRepository.hasStatusNotEqualsWithoutStepItem(parent.getItemId(), testItem.getItemId(), StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED;
            if (!parent.getItemResults().getStatus().equals((Object)newStatus) && parent.getItemResults().getStatus() != StatusEnum.IN_PROGRESS) {
                parent.getItemResults().setStatus(newStatus);
                this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(parent, projectId), user.getUserId(), user.getUsername()));
                this.changeStatusRecursively(parent, user, projectId);
            }
        }
    }

    void changeParentsStatusesToFailed(TestItem testItem, StatusEnum oldParentStatus, ReportPortalUser user, Long projectId) {
        if (!oldParentStatus.equals((Object)StatusEnum.FAILED) || oldParentStatus != StatusEnum.IN_PROGRESS) {
            TestItem parent;
            TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(parent, projectId);
            for (parent = testItem.getParent(); parent != null; parent = parent.getParent()) {
                parent.getItemResults().setStatus(StatusEnum.FAILED);
                this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(parent, projectId), user.getUserId(), user.getUsername()));
            }
            Launch launch = (Launch)this.launchRepository.findById((Object)testItem.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchId()}));
            if (launch.getStatus() != StatusEnum.IN_PROGRESS) {
                launch.setStatus(StatusEnum.FAILED);
            }
        }
    }
}

