/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.log.impl.SaveLogBinaryDataTask;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.attachment.AttachmentMetaInfo;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.LogBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Primary
@Transactional
public class CreateLogHandlerImpl
implements CreateLogHandler {
    @Autowired
    TestItemRepository testItemRepository;
    @Autowired
    TestItemService testItemService;
    @Autowired
    LaunchRepository launchRepository;
    @Autowired
    LogRepository logRepository;
    @Autowired
    private Provider<SaveLogBinaryDataTask> saveLogBinaryDataTask;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;

    @Override
    @Nonnull
    public EntryCreatedAsyncRS createLog(@Nonnull SaveLogRQ request, MultipartFile file, ReportPortalUser.ProjectDetails projectDetails) {
        this.validate(request);
        Optional itemOptional = this.testItemRepository.findByUuid(request.getItemUuid());
        if (itemOptional.isPresent()) {
            return this.createItemLog(request, (TestItem)itemOptional.get(), file, projectDetails.getProjectId());
        }
        Launch launch = (Launch)this.launchRepository.findByUuid(request.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{request.getLaunchUuid()}));
        return this.createLaunchLog(request, launch, file, projectDetails.getProjectId());
    }

    private EntryCreatedAsyncRS createItemLog(SaveLogRQ request, TestItem item, MultipartFile file, Long projectId) {
        Log log = new LogBuilder().addSaveLogRq(request).addTestItem(item).get();
        this.logRepository.save((Object)log);
        Launch effectiveLaunch = this.testItemService.getEffectiveLaunch(item);
        this.saveBinaryData(file, projectId, log.getId(), effectiveLaunch.getId(), item.getItemId(), effectiveLaunch.getUuid(), log.getUuid());
        return new EntryCreatedAsyncRS(log.getUuid());
    }

    private EntryCreatedAsyncRS createLaunchLog(SaveLogRQ request, Launch launch, MultipartFile file, Long projectId) {
        Log log = new LogBuilder().addSaveLogRq(request).addLaunch(launch).get();
        this.logRepository.save((Object)log);
        this.saveBinaryData(file, projectId, log.getId(), launch.getId(), null, launch.getUuid(), log.getUuid());
        return new EntryCreatedAsyncRS(log.getUuid());
    }

    private void saveBinaryData(MultipartFile file, Long projectId, Long logId, Long launchId, Long itemId, String launchUuid, String logUuid) {
        if (!Objects.isNull(file)) {
            SaveLogBinaryDataTask saveLogBinaryDataTask = ((SaveLogBinaryDataTask)this.saveLogBinaryDataTask.get()).withFile(file).withAttachmentMetaInfo(AttachmentMetaInfo.builder().withProjectId(projectId).withLaunchId(launchId).withItemId(itemId).withLogId(logId).withLaunchUuid(launchUuid).withLogUuid(logUuid).build());
            this.taskExecutor.execute((Runnable)saveLogBinaryDataTask);
        }
    }
}

